#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

# canvSticker.tcl
#
# Modified from original demo for tkSticker by Heribert Dahms
# (dahms@ifk20.mach.uni-karlsruhe.de)
#
# jeff at hobbs org, crrw@gmx.de

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

pack [canvas .c]
wm geometry . +30+30		;# For fvwm.
set delay 2000			;# Two seconds should be enough.
set i 0

if {[catch {.c create sticker 0 0 10 10} st]} {
    tk_messageBox -type ok -title "No sticker Item" \
	    -message "This build of vu does not include the sticker item"
    return
} else {
    .c delete st
}

proc step[incr i] {} {
    # I used a 75dpi screen for testing, but others should make no difference!
    puts {You'll see a small upright rectangle with "He" inside.}
    #.c create sticker 20 30 40 80 -text Hello -tags st
    .c create sticker 6m 10m 13m 27m -text Hello -tags st
}

proc step[incr i] {} {
    puts {You'll see the whole "Hello" drawn rotated 90 degrees.}
    .c itemconfigure st -orient vertical
}

proc step[incr i] {} {
    puts {The rectangle shrinks and the text is clipped to "Hell"}
    #.c coords st 20 30 40 60
    .c coords st 6m 10m 13m 20m
}

proc step[incr i] {} {
    puts {Now you'll read "ello"}
    .c itemconfigure st -lefttrunc yes
}

proc step[incr i] {} {
    puts {Enlarging the rectangle shows the complete "Hello" again}
    .c scale st 0 0 3 3
}

proc step[incr i] {} {
    puts {This time the text is repeated: "Hello", approx. 5mm space, "Hello"}
    .c itemconfigure st -space 5m
}

proc step[incr i] {} {
    puts {A vertical bar appears in the lower right\
	    region and text jumps to the left.}
    .c itemconfigure st -anchor n -relw .3 -relh .7 -relx .6 -rely .3 -bar red
}

proc step[incr i] {} {
    puts {Paint the backgound.}
    .c itemconfigure st -fill yellow
}

proc step[incr i] {} {
    puts {Let's test stippling.}
    .c itemconfigure st -stipple gray25
    #.c itemconfigure st -stipple @[file dirname [info script]]/m128_000.xbm
}

proc step[incr i] {} {
    puts {Finally a large outline forces a single "Hello" and shrinks the bar.}
    .c itemconfigure st -width 6m
}

for {set j 1} {$j < $i} {incr j} {
    after [expr {$delay * $j}] step$j
}

bind .  <q> { exit }
