#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

# oscilloscope.tcl
#
# Modified from original demo
#
# jeff at hobbs org, crrw@gmx.de

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

#---USAGE
set INFO "...the heart of a Realtime Oscilloscope,where the PC's
joystick port gives 4 digtal inputs and 4 analog 8 bit
values with an resolution of ~1 millisecond (!!!)
running Realtime Linux.
<p> creates DEMO.ps
<B1-Motion> see what happens"
puts $INFO

#---GEOMETRY
set FR  {20 20 420 360}
set CH0 {20 20 420 180}
set CH1 {20 180 420 360}
set T1  {30 176}

#---GUI
pack [canvas .c -width 440 -height 380] -fill both -expand 1

#---background
set frbg [.c create rect $FR -width 4 -fill aquamarine3 -tags {osc frbg}]

#---channel 0
set ch0 [eval .c create stripchart $CH0]
.c itemconfigure $ch0 \
	-fill   {} 		\
	-jumpscroll 0 		\
	-outline {} 		\
	-scaleline {}       	\
	-stripline   cyan     	\
	-tags {osc ch0}
#---channel 1
set ch1 [eval .c create stripchart $CH1]
.c itemconfigure $ch1 \
	-fill {} 		\
	-jumpscroll 0 		\
        -outline {} 		\
	-scaleline {}       	\
	-stripline   red     	\
        -tags {osc ch1}
#---frame
set frfg [.c create rect $FR -width 4  -tags {osc frfg} ]
#---position
set txt1 [.c create text $T1 -text "B1-Motion: X:%X\tY:%Y" \
	-anchor nw -tags {osc txt1}]

#---BINDINGS
bind .c <B1-Motion>     {
    .c itemconfigure $ch0 -values %x
    .c itemconfigure $ch1 -values %y
    .c itemconfigure $txt1  -text "B1-Motion: X:%X\tY:%Y"
}

bind . <v> {
    puts [.c itemcget $ch0 -values]
    puts [llength [.c itemcget $ch0 -values]]
}

bind . <p> {
    .c postscript -file DEMO.ps
    puts "DEMO.ps printed"
}

bind . <q> { exit }
