/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCDriver
implements Driver {
    public static final int MAJORVERSION = 1;
    private static Constructor makeConn = null;
    protected Connection conn;

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith("sqlite:/") || string.startsWith("jdbc:sqlite:/");
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        if (properties != null) {
            objectArray[1] = properties.getProperty("encoding");
        }
        if (objectArray[1] == null) {
            objectArray[1] = System.getProperty("SQLite.encoding");
        }
        try {
            this.conn = (Connection)makeConn.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return this.conn;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 20070915;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("encoding", "");
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{driverPropertyInfo};
        return driverPropertyInfoArray;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            String string;
            Class[] classArray;
            Class<?> clazz = null;
            classArray = new Class[]{Class.forName("java.lang.String"), classArray[0]};
            String string2 = System.getProperty("java.version");
            if (string2 == null || string2.startsWith("1.0")) {
                throw new Exception("unsupported java version");
            }
            if (string2.startsWith("1.1")) {
                string = "SQLite.JDBC1.JDBCConnection";
            } else if (string2.startsWith("1.2") || string2.startsWith("1.3")) {
                string = "SQLite.JDBC2.JDBCConnection";
            } else if (string2.startsWith("1.4")) {
                string = "SQLite.JDBC2x.JDBCConnection";
            } else if (string2.startsWith("1.5")) {
                string = "SQLite.JDBC2y.JDBCConnection";
                try {
                    Class.forName(string);
                }
                catch (Exception exception) {
                    string = "SQLite.JDBC2x.JDBCConnection";
                }
            } else {
                string = "SQLite.JDBC2z.JDBCConnection";
                try {
                    Class.forName(string);
                }
                catch (Exception exception) {
                    string = "SQLite.JDBC2y.JDBCConnection";
                    try {
                        Class.forName(string);
                    }
                    catch (Exception exception2) {
                        string = "SQLite.JDBC2x.JDBCConnection";
                    }
                }
            }
            clazz = Class.forName(string);
            makeConn = clazz.getConstructor(classArray);
            DriverManager.registerDriver(new JDBCDriver());
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

