/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Database;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCDriver
implements Driver {
    public static final int MAJORVERSION = 1;
    public static boolean sharedCache = false;
    public static String vfs = null;
    private static Constructor makeConn = null;
    protected Connection conn;

    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith("sqlite:/") || string.startsWith("jdbc:sqlite:/");
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = string;
        if (properties != null) {
            objectArray[1] = properties.getProperty("encoding");
            objectArray[2] = properties.getProperty("password");
            objectArray[3] = properties.getProperty("daterepr");
            objectArray[4] = properties.getProperty("vfs");
        }
        if (objectArray[1] == null) {
            objectArray[1] = System.getProperty("SQLite.encoding");
        }
        if (objectArray[4] == null) {
            objectArray[4] = vfs;
        }
        try {
            this.conn = (Connection)makeConn.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return this.conn;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 20110106;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("encoding", "");
        driverPropertyInfo = new DriverPropertyInfo("password", "");
        driverPropertyInfo = new DriverPropertyInfo("daterepr", "normal");
        driverPropertyInfo = new DriverPropertyInfo("vfs", vfs);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo, driverPropertyInfo, driverPropertyInfo};
        return driverPropertyInfoArray;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            String string;
            String string2;
            Class[] classArray;
            Class<?> clazz = null;
            classArray = new Class[]{Class.forName("java.lang.String"), classArray[0], classArray[0], classArray[0], classArray[0]};
            String string3 = System.getProperty("java.version");
            if (string3 == null || string3.startsWith("1.0")) {
                throw new Exception("unsupported java version");
            }
            if (string3.startsWith("1.1")) {
                string2 = "SQLite.JDBC1.JDBCConnection";
            } else if (string3.startsWith("1.2") || string3.startsWith("1.3")) {
                string2 = "SQLite.JDBC2.JDBCConnection";
            } else if (string3.startsWith("1.4")) {
                string2 = "SQLite.JDBC2x.JDBCConnection";
            } else if (string3.startsWith("1.5")) {
                string2 = "SQLite.JDBC2y.JDBCConnection";
                try {
                    Class.forName(string2);
                }
                catch (Exception exception) {
                    string2 = "SQLite.JDBC2x.JDBCConnection";
                }
            } else {
                string2 = "SQLite.JDBC2z.JDBCConnection";
                try {
                    Class.forName(string2);
                }
                catch (Exception exception) {
                    string2 = "SQLite.JDBC2y.JDBCConnection";
                    try {
                        Class.forName(string2);
                    }
                    catch (Exception exception2) {
                        string2 = "SQLite.JDBC2x.JDBCConnection";
                    }
                }
            }
            clazz = Class.forName(string2);
            makeConn = clazz.getConstructor(classArray);
            DriverManager.registerDriver(new JDBCDriver());
            try {
                string = System.getProperty("SQLite.sharedcache");
                if (string != null && (string.startsWith("y") || string.startsWith("Y"))) {
                    sharedCache = Database._enable_shared_cache(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = System.getProperty("SQLite.vfs");
                if (string != null) {
                    vfs = string;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

