#include <dlfcn.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*
 * "run.so" inspired by Win32 rundll.exe
 *
 * Loads a shared library and calls a main() like function.
 *
 */

int
main(int argc, char **argv)
{
    char *lib, *entry = "main";
    void *dl;
    int (*dlent)(int, char **);
    int nargc = argc;

    if (argc < 2) {
	char *prog = strrchr(argv[0], '/');

	if (prog != NULL) {
	    ++prog;
	} else {
	    prog = argv[0];
	}
	fprintf(stderr, "usage: %s library [entry [arg ...]]\n", prog);
	exit(1);
    }
    lib = argv[1];
    nargc--;
    if (argc > 2) {
	entry = argv[2];
	nargc--;
    }
    dlerror();
    dl = dlopen(lib, RTLD_NOW);
    if (dl == NULL) {
	fprintf(stderr, "%s\n", dlerror());
	exit(2);
    }
    dlerror();
    dlent = (int (*)(int, char **)) dlsym(dl, entry);
    if (dlent == NULL) {
	fprintf(stderr, "%s\n", dlerror());
	exit(3);
    }
    if (nargc > 1) {
	memmove(argv + 1, argv + 3, nargc * sizeof (char *));
    } else {
	argv[1] = NULL;
    }
    return dlent(nargc, argv);
}
