# Android demo

proc ademo {} {
    global ademo
    if {[winfo exists .ademo]} {
	wm withdraw .ademo
	wm deiconify .ademo
	return
    }
    toplevel .ademo
    wm protocol .ademo WM_DELETE_WINDOW ademo_done
    wm attribute .ademo -fullscreen 1

    labelframe .ademo.am -text "Accelerometer" -padx 3 -pady 3
    pack .ademo.am -side top -padx 3 -pady 3 -anchor nw
    set row 0
    foreach axis {1 2 3} {
        label .ademo.am.a$axis -text $axis
        label .ademo.am.v$axis -textvariable ademo(a$axis) -width 8 \
	    -relief sunken -bg #FFFFFF
	grid .ademo.am.a$axis -row $row -column 0
	grid .ademo.am.v$axis -row $row -column 1
	incr row
    }
    set ademo(accel) 0
    frame .ademo.am.b
    grid .ademo.am.b -row $row -column 0 -columnspan 2 -padx 3
    radiobutton .ademo.am.b.on -text On -width 5 -variable ademo(accel) \
	-value 1 -command {sdltk accelerometer $ademo(accel)} \
	-indicatoron 0 -selectcolor [.ademo.am.b cget -bg]
    radiobutton .ademo.am.b.off -text Off -width 5 -variable ademo(accel) \
	-value 0 -command {sdltk accelerometer $ademo(accel)} \
	-indicatoron 0 -selectcolor [.ademo.am.b cget -bg]
    pack .ademo.am.b.on .ademo.am.b.off -side left -padx 3 -pady 3 -expand 1
    bind .ademo <<Accelerometer>> {set ademo(a%s) %x}

    labelframe .ademo.fi -text "Finger Events" -padx 3 -pady 3
    pack .ademo.fi -side top -padx 3 -pady 3 -anchor nw
    set row 0
    label .ademo.fi.lx -text X
    label .ademo.fi.ly -text Y
    label .ademo.fi.ldx -text DX
    label .ademo.fi.ldy -text DY
    label .ademo.fi.lp -text P
    grid .ademo.fi.lx -row $row -column 1
    grid .ademo.fi.ly -row $row -column 2
    grid .ademo.fi.ldx -row $row -column 3
    grid .ademo.fi.ldy -row $row -column 4
    grid .ademo.fi.lp -row $row -column 5
    incr row
    foreach f {1 2 3 4 5} {
        label .ademo.fi.n$f -text $f
        label .ademo.fi.x$f -textvariable ademo(fx$f) -width 8 \
	    -relief sunken -bg #FFFFFF
        label .ademo.fi.y$f -textvariable ademo(fy$f) -width 8 \
	    -relief sunken -bg #FFFFFF
        label .ademo.fi.dx$f -textvariable ademo(fdx$f) -width 8 \
	    -relief sunken -bg #FFFFFF
        label .ademo.fi.dy$f -textvariable ademo(fdy$f) -width 8 \
	    -relief sunken -bg #FFFFFF
        label .ademo.fi.p$f -textvariable ademo(fp$f) -width 8 \
	    -relief sunken -bg #FFFFFF
	grid .ademo.fi.n$f -row $row -column 0
	grid .ademo.fi.x$f -row $row -column 1
	grid .ademo.fi.y$f -row $row -column 2
	grid .ademo.fi.dx$f -row $row -column 3
	grid .ademo.fi.dy$f -row $row -column 4
	grid .ademo.fi.p$f -row $row -column 5
	incr row
    }
    bind .ademo <<FingerDown>> {ademo_finger down %s %x %y %X %Y %t}
    bind .ademo <<FingerUp>> {ademo_finger up %s %x %y %X %Y %t}
    bind .ademo <<FingerMotion>> {ademo_finger motion %s %x %y %X %Y %t}

    labelframe .ademo.lc -text "App Life Cycle" -padx 3 -pady 3
    pack .ademo.lc -side top -padx 3 -pady 3 -anchor nw
    text .ademo.lc.t -width 35 -height 8 -bg #FFFFFF -state disabled
    pack .ademo.lc.t -side top
    foreach ev {LowMemory Terminating WillEnterBackground
	DidEnterBackground WillEnterForeground DidEnterForeground} {
	bind .ademo <<$ev>> [list ademo_lcevt $ev]
    }

    frame .ademo.b -padx 3 -pady 3
    pack .ademo.b -side top -padx 3 -pady 3 -anchor nw
    button .ademo.b.x -text "Close" -command ademo_done
    button .ademo.b.c -text "Console ..." -command {
	console hide ; console show
    }
    pack .ademo.b.x .ademo.b.c -side left -padx 5
}

proc ademo_lcevt {name} {
   .ademo.lc.t config -state normal
   .ademo.lc.t insert end $name
   .ademo.lc.t insert end "\n"
   .ademo.lc.t yview end
   .ademo.lc.t config -state disabled
}

proc ademo_finger {op id x y dx dy p} {
    global ademo
    if {$id < 1 || $id > 6} {
	return
    }
    set ademo(fx$id) $x
    set ademo(fy$id) $y
    set ademo(fdx$id) $dx
    set ademo(fdy$id) $dy
    set ademo(fp$id) $p
}

proc ademo_done {} {
    global ademo
    sdltk accelerometer 0
    destroy .ademo
    unset ademo
}

