#ifndef _SDLTKINT_H
#define _SDLTKINT_H

#include <SDL2/SDL.h>
#include "tkFont.h"

/*
 * For C++ compilers, use extern "C"
 */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _Colormap _Colormap;
typedef struct _Cursor _Cursor;
typedef struct _Font _Font;
typedef struct _Pixmap _Pixmap;
typedef struct _Window _Window;
typedef struct _XSQEvent _XSQEvent;
typedef struct _DecFrame *DecFrame;

/* X11 Colormap internal rep */
struct _Colormap
{
    int whatever;
};

/* X11 Cursor internal rep */
struct _Cursor
{
    int whatever;
};

typedef struct GlyphIndexHash
{
    int refCnt;
    char *familyName;
    unsigned long faceFlags;
    unsigned long styleFlags;
    char *xlfdPattern;
    int hashLoaded;
    Tcl_HashTable hash;
} GlyphIndexHash;

/* X11 Font internal rep */
struct _Font {
    int refCnt;
    const char *file; /* malloc */
    int index; /* face index in file */
    int size; /* pixel size */
    const char *xlfd; /* malloc */
    GlyphIndexHash *glyph_index_hash;
    int fixedWidth;
    XFontStruct *font_struct;
};

enum {
    SDLTK_GRAY8,
    SDLTK_RGB565,
    SDLTK_BGR565,
    SDLTK_RGB24,
    SDLTK_BGR24,
    SDLTK_RGBA32,
    SDLTK_ARGB32,
    SDLTK_BGRA32,
    SDLTK_ABGR32,
    SDLTK_BITMAP
};

/* Drawable type */
#define DT_PIXMAP 1
#define DT_WINDOW 2

/* X11 Pixmap internal rep */
struct _Pixmap
{
    int type; /* must be first */
    SDL_Surface *sdl; /* SDLTK_RGB24 etc */
    int format;
};

/* X11 Window internal rep */
struct _Window
{
    int type; /* must be first */
    _Window *parent; /* May be root; NULL for root */
    _Window *child; /* first child (highest in stacking order) */
    _Window *next; /* next sibling (lower in stacking order) */
    _Window *master; /* Master if this is a transient */
    XWindowAttributes atts;
    int fullscreen;
    int clazz;
    XWindowAttributes atts_saved;
    XSizeHints size;
    int parentWidth, parentHeight; /* Our width/height + 2*atts.border_width */
    TkWindow *tkwin; /* NULL for decorative frame */
    DecFrame dec; /* Only for decorative frame */
    SDL_Surface *sdl; /* Only for decorative frame and override_redirect */
    int format; /* SDLTK_RGB24 etc */
    const char *title; /* malloc'd. Tk will set this for the wrapper */
    Region visRgnInParent; /* Contains the areas of the window which are
			    * not obscured by ancestors or children of
			    * ancestors.
			    * If the window or any ancestor is unmapped, the
			    * region is empty.
			    * For the root, this region covers the entire
			    * screen area.
			    * For a double-buffered toplevel, this region
			    * covers the entire area of the window.
			    */
    Region visRgn; 	/* Same as visRgnInParent, minus areas of any mapped
			 * children.
			 * This is the region used to restrict drawing in the
			 * window.
			 */
    Region dirtyRgn; /* For toplevels only. Holds the parts
		      * of the window that need to be updated
		      * on screen. */
};

/* Undefined struct in Xlib.h */
/* This event goes into Display.head event queue */
struct _XSQEvent
{
    SDL_Event sdl_event;
    XEvent event;
    _XSQEvent *next;
};

#define DEC_FRAME_WIDTH 6
#define DEC_TITLE_HEIGHT 20

#define IS_PIXMAP(d) (((_Pixmap *) (d))->type == DT_PIXMAP)
#define IS_WINDOW(d) (((_Window *) (d))->type == DT_WINDOW)
#define IS_ROOT(w) ((Window) w == SdlTkX_screen->root)
#define PARENT_IS_ROOT(w) IS_ROOT(((_Window *) w)->parent)

extern SDL_Window *SdlTk_sdlscreen;
extern SDL_Surface *SdlTk_sdlsurf;
extern SDL_Renderer *SdlTk_sdlrend;
extern SDL_Texture *SdlTk_sdltex;
extern _Window *SdlTkX_root;
extern Display *SdlTkX_display;
extern Screen *SdlTkX_screen;
extern Window SdlTkX_focus_window;
extern Window SdlTkX_focus_window_old;
extern Window SdlTkX_focus_window_not_override;

#define DBG_EVENTS 0x00000001
#define DBG_WINDOWS 0x00000002
#define DBG_FIXME 0x00000004
#define DBG_DRAW 0x00000008
#define DBG_FONTS 0x00000010
#define DBG_FOCUS 0x00000020
#define DBG_PIXMAPS 0x00000040
#define DBG_SURFACE 0x00000080
#define DBG_VISRGN 0x00000100

extern int SdlTkX_dbg;

/* SdlTkInt.c */
extern void SdlTkAttachTkWindow(Window w, TkWindow *tkwin);
extern void SdlTkScreenChanged(void);
extern int SdlTkTranslateEvent(SDL_Event *sdl_event, XEvent *event);
extern void SdlTkGenerateConfigureNotify(Display *, Window);
extern void SdlTkGenerateExpose(Display *, Window w, int x, int y, int width, int height);
extern void SdlTkRootCoords(_Window *_w, int *x, int *y);
extern _Window *SdlTkToplevelForWindow(_Window *_w, int *x, int *y);
extern _Window *SdlTkWrapperForWindow(_Window *_w);
extern _Window *SdlTkTopVisibleWrapper(void);
extern SDL_Surface *SdlTkGetDrawableSurface(Drawable d, int *x, int *y, int *format);
extern _Window *SdlTkPointToWindow(_Window *_w, int x, int y, Bool mapped);
extern void SdlTkRemoveFromParent(_Window *_w);
extern void SdlTkRestackWindow(_Window *_w, _Window *sibling, int stack_mode);
extern void SdlTkRestackTransients(_Window *_w);
extern void SdlTkBringToFrontIfNeeded(_Window *_w);
extern int SdlTkIsTransientOf(_Window *_w, _Window *other);
extern void SdlTkCalculateVisibleRegion(_Window *_w);
extern Region SdlTkGetVisibleRegion(_Window *_w);
#define VRC_DO_PARENT 0x0001
#define VRC_SELF_ONLY 0x0002
#define VRC_MOVE 0x0004
#define VRC_CHANGED 0x0008
extern void SdlTkVisRgnChanged(_Window *_w, int flags, int x, int y);
extern void SdlTkLostFocusWindow(void);
extern void SdlTkDirtyAll(Window w);
extern void SdlTkDirtyArea(Window w, int x, int y, int width, int height);
extern void SdlTkDirtyRegion(Window w, Region rgn);
extern int SdlTkGrabCheck(_Window *_w, int *othergrab);
extern void SdlTkClearPointer(_Window *w);
extern unsigned long TkpGetMS(void);

/* SdlTkAGG.c */
extern void SdlTkGfxDrawArc(Drawable d, GC gc, int x, int y,
    unsigned int width, unsigned int height, int start, int extent);
extern void SdlTkGfxDrawBitmap(Drawable src, Drawable dest, GC gc,
    int src_x, int src_y, unsigned int width, unsigned int height,
    int dest_x, int dest_y);
extern void SdlTkGfxDrawLines(Drawable d, GC gc, XPoint *points, int npoints, int mode);
extern void SdlTkGfxDrawPoint(Drawable d, GC gc, int x, int y);
extern void SdlTkGfxDrawRect(Drawable d, GC gc, int x, int y, int w, int h);
extern void SdlTkGfxFillArc(Drawable d, GC gc, int x, int y,
    unsigned int width, unsigned int height, int start, int extent);
extern void SdlTkGfxFillPolygon(Drawable d, GC gc, XPoint *points, int npoints, int shape, int mode);
extern void SdlTkGfxFillRegion(Drawable d, Region rgn, Uint32 pixel);
extern void SdlTkGfxFillRect(Drawable d, GC gc, int x, int y, int w, int h);
extern XFontStruct *SdlTkGfxAllocFontStruct(_Font *_f);
extern void SdlTkGfxDrawString(Drawable d, GC gc, int x, int y, const char *string, int length);
extern int SdlTkGfxTextWidth(Font f, const char *string, int length);
extern void *SdlTkGetFTStream(const char *pathname);
extern void SdlTkFontInitCharWidths(Font f, int widths[256]);

/* SdlTkGfx.c */
extern int SdlTkPixelFormat(SDL_Surface *sdl);
extern void SdlTkGfxBlitRegion(SDL_Surface *src, Region rgn, SDL_Surface *dest, int dest_x, int dest_y);
extern void SdlTkGfxCopyArea(Drawable src, Drawable dest, GC gc, int src_x, int src_y, unsigned int width, unsigned int height, int dest_x, int dest_y);
extern int SdlTkGfxExposeRegion(Window w, Region dirtyRgn);
extern void SdlTkGfxUpdateRegion(SDL_Window *screen, Region rgn);
extern unsigned long SdlTkImageGetPixel(XImage *image, int x, int y);
extern int SdlTkImagePutPixel(XImage *image, int x, int y, unsigned long pixel);
extern int SdlTkImageDestroy(XImage *image);
extern void SdlTkGfxPutImage(Drawable d, XImage* image, int src_x, int src_y,
    int dest_x, int dest_y, unsigned int width, unsigned int height);

/* SdlTkUtils.c */
extern Region SdlTkRgnPoolGet(void);
extern void SdlTkRgnPoolFree(Region r);
extern char **SdlTkListFonts(const char *xlfd, int *count);
extern Font SdlTkFontLoadXLFD(const char *xlfd);
extern int SdlTkFontInit(Tcl_Interp *interp);
extern void SdlTkFontFreeFont(XFontStruct *fontStructPtr);
extern int SdlTkFontIsFixedWidth(XFontStruct *fontStructPtr);
extern int SdlTkFontHasChar(XFontStruct *fontStructPtr, char *buf);
extern int SdlTkFontCanDisplayChar(char *xlfd, TkFontAttributes *faPtr, int ch);
extern unsigned SdlTkGetNthGlyphIndex(_Font *_f, const char *s, int n);

/* decframe.c */
extern int SdlTkDecSetActive(_Window *_w, int active);
extern int SdlTkDecSetDraw(_Window *_w, int draw);
extern void SdlTkDecDrawFrame(_Window *_w);
extern int SdlTkDecFrameEvent(_Window *_w, SDL_Event *sdl_event, int x, int y);
extern void SdlTkDecCreate(_Window *_w);
extern void SdlTkDecDestroy(_Window *_w);

#define XSetEmptyRegion(r) XSubtractRegion(r,r,r)

/*
 * end block for C++
 */
    
#ifdef __cplusplus
}
#endif

#endif /* _SDLTKINT_H */
