#include "tkInt.h"
#include "tkIntPlatDecls.h"
#include "SdlTkInt.h"
#include "SdlTkX.h"
#include <SDL2/SDL_syswm.h>
#include <SDL2/SDL_scancode.h>

char *SdlTk_arg_width = NULL;
char *SdlTk_arg_height = NULL;
int SdlTk_arg_fullscreen = 0;
int SdlTk_arg_resizable = 0;
int SdlTk_arg_noborder = 0;

static Atom mwm_atom = None;
static Atom nwms_atom = None;
static Atom nwmsf_atom = None;
static Atom clipboard = None;

Pixmap XCreatePixmap();

/*
 * Undocumented Xlib internal function
 */

int
_XInitImageFuncPtrs(XImage *image)
{
    return 0;
}

XClassHint *
XAllocClassHint(void)
{
    XClassHint *hint;

    hint = (XClassHint *) ckalloc(sizeof (XClassHint));
    return hint;
}

int
XAllocColor(Display *display, Colormap colormap, XColor *color)
{
    /* NOTE: If this changes, update TkpGetPixel */
    Uint8 r = (color->red / 65535.0) * 255.0;
    Uint8 g = (color->green / 65535.0) * 255.0;
    Uint8 b = (color->blue / 65535.0) * 255.0;

    display->request++;
    color->pixel = SDL_MapRGB(SdlTk_sdlsurf->format, r, g, b);
    return 1;
}

Status
XAllocNamedColor(display, colormap, color_name, screen_def_return,
	exact_def_return)
    Display* display;
    Colormap colormap;
    const char* color_name;
    XColor* screen_def_return;
    XColor* exact_def_return;
{
    /* xcolors.c */
    if (XParseColor(display, colormap, color_name, exact_def_return) == 1) {
	*screen_def_return = *exact_def_return;
	return XAllocColor(display, colormap, screen_def_return);
    }
    return 0;
}

XSizeHints *
XAllocSizeHints(void)
{
    return (XSizeHints *) ckalloc(sizeof (XSizeHints));
}

void
XBell(Display *display, int percent)
{
}

void
XChangeGC(Display *d, GC gc, unsigned long mask, XGCValues *values)
{
    d->request++;

    if (mask & GCFunction) {
	gc->function = values->function;
    }
    if (mask & GCPlaneMask) {
	gc->plane_mask = values->plane_mask;
    }
    if (mask & GCForeground) {
	gc->foreground = values->foreground;
    }
    if (mask & GCBackground) {
	gc->background = values->background;
    }
    if (mask & GCLineWidth) {
	gc->line_width = values->line_width;
    } 
    if (mask & GCLineStyle) {
	gc->line_style = values->line_style;
    }
    if (mask & GCCapStyle) {
	gc->cap_style = values->cap_style;
    }
    if (mask & GCJoinStyle) {
	gc->join_style = values->join_style;
    }
    if (mask & GCFillStyle) {
	gc->fill_style = values->fill_style;
    }
    if (mask & GCFillRule) {
	gc->fill_rule = values->fill_rule;
    }
    if (mask & GCArcMode) {
	gc->arc_mode = values->arc_mode;
    }
    if (mask & GCTile) {
	gc->tile = values->tile;
    }
    if (mask & GCStipple) {
	gc->stipple = values->stipple;
    }
    if (mask & GCTileStipXOrigin) {
	gc->ts_x_origin = values->ts_x_origin;
    }
    if (mask & GCTileStipYOrigin) {
	gc->ts_y_origin = values->ts_y_origin;
    }
    if (mask & GCFont) {
	gc->font = values->font;
    }
    if (mask & GCSubwindowMode) {
	gc->subwindow_mode = values->subwindow_mode;
    }
    if (mask & GCGraphicsExposures) {
	gc->graphics_exposures = values->graphics_exposures;
    }
    if (mask & GCClipXOrigin) {
	gc->clip_x_origin = values->clip_x_origin;
    }
    if (mask & GCClipYOrigin) {
	gc->clip_y_origin = values->clip_y_origin;
    }
    if (mask & GCClipMask) {
	XSetClipMask(d, gc, values->clip_mask);
    }
    if (mask & GCDashOffset) {
	gc->dash_offset = values->dash_offset;
    }
    if (mask & GCDashList) {
	gc->dashes = values->dashes;
	(&gc->dashes)[1] = 0;
    }
}

void
XChangeProperty(Display *display, Window w, Atom property, Atom type,
		int format, int mode, _Xconst unsigned char *data,
		int nelements)
{
    _Window *_w = (_Window *) w;

    /* UpdateTitle() */
    if ((property > XA_LAST_PREDEFINED) &&
	    !strcmp((char *) property, "_NET_WM_NAME")) {

	if (_w->title != NULL)
	    ckfree((char *) _w->title);
	_w->title = ckalloc(nelements + 1); /* UTF-8 */
	strcpy((char *) _w->title, (char *) data);

	/* Redraw frame titlebar */
	if (_w->parent != NULL && _w->parent->dec != NULL) {
	    SdlTkDecSetDraw(_w->parent, 1);
	    SdlTkScreenChanged();
	}
    }
    if ((property == mwm_atom) && (type == mwm_atom)) {
	long *props = (long *) data;

	if ((props[0] & 2) && !_w->atts.override_redirect) {
	    XSetWindowAttributes atts;

	    atts.override_redirect = props[2] ? 0 : 1;
	    if (_w->atts.override_redirect != atts.override_redirect) {
		XChangeWindowAttributes(display, w, CWOverrideRedirect, &atts); 
	    }
	}
    }
    if (property == nwms_atom) {
	int i, fullscreen = 0;
	Atom *props = (Atom *) data;
	XPropertyEvent xproperty;
	_Window *_ww = _w;

	for (i = 0; i < nelements; i++) {
	    if (props[i] == nwmsf_atom) {
		fullscreen = 1;
		break;
	    }
	}
	if (fullscreen && !_w->fullscreen) {
	    int xx, yy, ww, hh;

	    _w->atts_saved = _w->atts;
	    xx = yy = 0;
	    ww = SdlTk_sdlsurf->w;
	    hh = SdlTk_sdlsurf->h;
	    if (_w->parent != NULL && _w->parent->dec != NULL) {
		xx -= DEC_FRAME_WIDTH;
		yy -= DEC_TITLE_HEIGHT;
		ww += DEC_FRAME_WIDTH * 2;
		hh += DEC_TITLE_HEIGHT + DEC_FRAME_WIDTH;
	    }
	    XMoveResizeWindow(display, w, xx, yy, ww, hh);
	    while (!IS_ROOT((Window) _ww)) {
		_ww->fullscreen = 1;
		_ww = _ww->parent;
	    }
	} else if (!fullscreen && _w->fullscreen) {
	    while (!IS_ROOT((Window) _ww)) {
		_ww->fullscreen = 0;
		_ww = _ww->parent;
	    }
	    XMoveResizeWindow(display, w,
			      _w->atts_saved.x, _w->atts_saved.y,
			      _w->atts_saved.width, _w->atts_saved.height);
	}
	memset(&xproperty, 0, sizeof (xproperty));
	xproperty.type = PropertyNotify;
	xproperty.atom = nwms_atom;
	xproperty.display = display;
	xproperty.window = (Window) _w;
	xproperty.state = PropertyNewValue;
	Tk_QueueWindowEvent((XEvent *) &xproperty, TCL_QUEUE_TAIL);
    }
    /* FIXME: _NET_WM_ICON_NAME as well */
}

void
XChangeWindowAttributes(Display *display, Window w,
			unsigned long valueMask,
			XSetWindowAttributes *attributes)
{
    _Window *_w = (_Window *) w;

    if (valueMask & CWCursor) {
	XDefineCursor(display, w, attributes->cursor);
    }
    if (valueMask & CWEventMask) {
	_w->atts.your_event_mask = attributes->event_mask;
    }
    if (valueMask & CWOverrideRedirect) {

	/* Tk won't call us unless it changed */
	_w->atts.override_redirect = attributes->override_redirect;

	/* Is override_redirect, wasn't before */
	if (attributes->override_redirect) {

	    /* Decorative frame may not have been allocated yet
	     * if the window was never mapped */
	    if (_w->parent != NULL && _w->parent->dec != NULL) {
		/* Reparent to root */
		XReparentWindow(display, w, SdlTkX_screen->root,
		    _w->parent->atts.x,
		    _w->parent->atts.y);
		SdlTkGenerateConfigureNotify(display, w);
	    }

	/* Was override_redirect, isn't now */
	} else {
	    if (_w->sdl != NULL) {
		SDL_FreeSurface(_w->sdl);
		_w->sdl = NULL;
	    }
	    XUnmapWindow(display, w);
	    XMapWindow(display, w);
	}
    }
}

#if 0
void
XClipBox(Region r, XRectangle *rect_return)
{
}
#endif

int
XCloseDisplay(Display *display)
{
    return 0;
}

void
XConfigureWindow(Display *display, Window w, unsigned int value_mask,
		 XWindowChanges *values)
{
    _Window *_w = (_Window *) w;

    display->request++;

    /* I don't think this border_width is ever used, so hard to test it */
    /* A widget's -borderwidth option is completely different */
    if (value_mask & CWBorderWidth) {
	_w->atts.border_width = values->border_width;
	_w->parentWidth = _w->atts.width + 2 * values->border_width;
	_w->parentHeight = _w->atts.height + 2 * values->border_width;
	SdlTkScreenChanged();
    }

    /* Need this for Tk_RestackWindow and Tk_MakeWindowExist */
    if (value_mask & CWStackMode) {
	_Window *sibling = NULL;

	if (value_mask & CWSibling)
	    sibling = (_Window *) values->sibling;

	SdlTkRestackWindow(_w, sibling, values->stack_mode);
	/*SdlTkRestackTransients(_w); -- this isn't a toplevel */

	SdlTkScreenChanged();
    }
}

int
XConvertSelection(Display *display, Atom selection, Atom target,
		  Atom property, Window requestor, Time time)
{
    return 0;
}

void
XCopyArea(Display *display, Drawable src, Drawable dest, GC gc,
	  int src_x, int src_y, unsigned int width, unsigned int height,
	  int dest_x, int dest_y)
{
    display->request++;

    SdlTkGfxCopyArea(src, dest, gc, src_x, src_y, width, height,
		     dest_x, dest_y);

    if (IS_WINDOW(dest)) {
	TkpClipMask *clipPtr = (TkpClipMask *) gc->clip_mask;
	SdlTkScreenChanged();
	if (clipPtr && clipPtr->type == TKP_CLIP_REGION) {
	    Region clipRgn = (Region) clipPtr->value.region;
	    SdlTkDirtyRegion(dest, clipRgn);
	} else {
	    SdlTkDirtyArea(dest, dest_x, dest_y, width, height);
	}
    }
}

void
XCopyPlane(Display *display, Drawable src, Drawable dest, GC gc,
	   int src_x, int src_y, unsigned int width, unsigned int height,
	   int dest_x, int dest_y, unsigned long plane)
{
    display->request++;

    SdlTkGfxDrawBitmap(src, dest, gc, src_x, src_y, width, height,
		       dest_x, dest_y);

    if (IS_WINDOW(dest))
	SdlTkScreenChanged();
}

Pixmap
XCreateBitmapFromData(Display *display, Drawable d, _Xconst char *data,
		      unsigned int width, unsigned int height)
{
    XImage ximage;
    Pixmap pix;
    _Pixmap *_p;
    SDL_Surface *sdl;
    SDL_Color colors[2];
    SDL_Palette *pal;

    /* Use 1 byte-per-pixel for efficient drawing/stippling */
    sdl = SDL_CreateRGBSurface(SDL_SWSURFACE, width, height,
	8, 0, 0, 0, 0);
    if (sdl == NULL)
	return None;

    /* New 8-bit surfaces have an empty palette. Set the palette to black
     * and white. */
    colors[0].r = colors[0].g = colors[0].b = 255;
    colors[1].r = colors[1].g = colors[1].b = 0;
    colors[0].a = colors[1].a = 255;
    pal = SDL_AllocPalette(256);
    SDL_SetPaletteColors(pal, colors + 1, 0, 1);
    SDL_SetPaletteColors(pal, colors + 0, 255, 1);
    SDL_SetSurfacePalette(sdl, pal);
    SDL_FreePalette(pal);

    _p = (_Pixmap *) ckalloc(sizeof (_Pixmap));
    memset(_p, '\0', sizeof (_Pixmap));
    _p->type = DT_PIXMAP;
    _p->sdl = sdl;
    _p->format = SdlTkPixelFormat(sdl);

    pix = (Pixmap) _p;

    ximage.height = height;
    ximage.width = width;
    ximage.depth = 1;
    ximage.bits_per_pixel = 1;
    ximage.xoffset = 0;
    ximage.format = XYPixmap;
    ximage.data = (char *)data;
    ximage.byte_order = LSBFirst;
    ximage.bitmap_unit = 8;
    ximage.bitmap_bit_order = LSBFirst;
    ximage.bitmap_pad = 8;
    ximage.bytes_per_line = (width+7)/8;
    ximage.red_mask = 1;
    ximage.green_mask = 1;
    ximage.blue_mask = 1;

    XPutImage(display, pix, None, &ximage, 0, 0, 0, 0, width, height);

    return(pix);
}

Colormap
XCreateColormap(Display *display, Window w, Visual *visual, int alloc)
{
    _Colormap *_colormap;

    display->request++;

    _colormap = (_Colormap *) ckalloc(sizeof (_Colormap));
    _colormap->whatever = 1234;

    return (Colormap) _colormap;
}

GC
XCreateGC(Display *display, Drawable d, unsigned long mask, XGCValues *values)
{
    GC gp;

    display->request++;

/*
 * In order to have room for a dash list, MAX_DASH_LIST_SIZE extra chars are
 * defined, which is invisible from the outside. The list is assumed to end
 * with a 0-char, so this must be set explicitely during initialization.
 */

#define MAX_DASH_LIST_SIZE 10

    gp = (XGCValues *)ckalloc(sizeof (XGCValues) + MAX_DASH_LIST_SIZE);
    if (!gp) {
	return None;
    }
    memset(gp, '\0', sizeof (XGCValues) + MAX_DASH_LIST_SIZE);

    gp->function = 	(mask & GCFunction) 	?values->function	:GXcopy;
    gp->plane_mask = 	(mask & GCPlaneMask) 	?values->plane_mask 	:~0;
    gp->foreground = 	(mask & GCForeground) 	?values->foreground 	:0;
    gp->background = 	(mask & GCBackground) 	?values->background 	:0xffffff;
    gp->line_width = 	(mask & GCLineWidth)	?values->line_width	:1;	
    gp->line_style = 	(mask & GCLineStyle)	?values->line_style	:LineSolid;
    gp->cap_style =  	(mask & GCCapStyle)	?values->cap_style	:0;
    gp->join_style = 	(mask & GCJoinStyle)	?values->join_style	:0;
    gp->fill_style =  	(mask & GCFillStyle)	?values->fill_style	:FillSolid;
    gp->fill_rule =  	(mask & GCFillRule)	?values->fill_rule	:WindingRule;
    gp->arc_mode = 	(mask & GCArcMode)	?values->arc_mode	:ArcPieSlice;
    gp->tile = 		(mask & GCTile)		?values->tile		:None;
    gp->stipple = 	(mask & GCStipple)	?values->stipple	:None;
    gp->ts_x_origin = 	(mask & GCTileStipXOrigin)	?values->ts_x_origin:0;
    gp->ts_y_origin = 	(mask & GCTileStipYOrigin)	?values->ts_y_origin:0;
    gp->font = 		(mask & GCFont)		?values->font		:None;
    gp->subwindow_mode = (mask & GCSubwindowMode)?values->subwindow_mode:ClipByChildren;
    gp->graphics_exposures = (mask & GCGraphicsExposures)?values->graphics_exposures:True;
    gp->clip_x_origin = (mask & GCClipXOrigin)	?values->clip_x_origin	:0;
    gp->clip_y_origin = (mask & GCClipYOrigin)	?values->clip_y_origin	:0;
    gp->dash_offset = 	(mask & GCDashOffset)	?values->dash_offset	:0;
    gp->dashes = 	(mask & GCDashList)	?values->dashes		:4;
    (&(gp->dashes))[1] = 	0;

    if (mask & GCClipMask) {
	gp->clip_mask = (Pixmap)ckalloc(sizeof (TkpClipMask));
	((TkpClipMask*)gp->clip_mask)->type = TKP_CLIP_PIXMAP;
	((TkpClipMask*)gp->clip_mask)->value.pixmap = values->clip_mask;
    } else {
	gp->clip_mask = None;
    }
    return gp;
}

int
XCopyGC(Display *display, GC src, unsigned long mask, GC dest)
{
    display->request++;

    if (mask & GCFunction)
        dest->function = src->function;
    if (mask & GCPlaneMask)
        dest->plane_mask = src->plane_mask;
    if (mask & GCForeground)
        dest->foreground = src->foreground;
    if (mask & GCBackground)
        dest->background = src->background;
    if (mask & GCLineWidth)
        dest->line_width = src->line_width;
    if (mask & GCLineStyle)
        dest->line_style = src->line_style;
    if (mask & GCCapStyle)
        dest->cap_style = src->cap_style;
    if (mask & GCJoinStyle)
        dest->join_style = src->join_style;
    if (mask & GCFillStyle)
        dest->fill_style = src->fill_style;
    if (mask & GCFillRule)
        dest->fill_rule = src->fill_rule;
    if (mask & GCArcMode)
        dest->arc_mode = src->arc_mode;
    if (mask & GCTile)
        dest->tile = src->tile;
    if (mask & GCStipple)
        dest->stipple = src->stipple;
    if (mask & GCTileStipXOrigin)
        dest->ts_x_origin = src->ts_x_origin;
    if (mask & GCTileStipYOrigin)
        dest->ts_y_origin = src->ts_y_origin;
    if (mask & GCFont)
        dest->font = src->font;
    if (mask & GCSubwindowMode)
        dest->subwindow_mode = src->subwindow_mode;
    if (mask & GCGraphicsExposures)
        dest->graphics_exposures = src->graphics_exposures;
    if (mask & GCClipXOrigin)
        dest->clip_x_origin = src->clip_x_origin;
    if (mask & GCClipYOrigin)
        dest->clip_y_origin = src->clip_y_origin;
    if (mask & GCDashOffset)
        dest->dash_offset = src->dash_offset;
    if (mask & GCDashList)
        dest->dashes = src->dashes;
    if (mask & GCClipMask) {
        if (dest->clip_mask == None &&
	    src->clip_mask != None) {
	    dest->clip_mask = (Pixmap) ckalloc(sizeof (TkpClipMask));
	    ((TkpClipMask *) dest->clip_mask)->type = TKP_CLIP_PIXMAP;
	    ((TkpClipMask *) dest->clip_mask)->value.pixmap =
		((TkpClipMask *) src->clip_mask)->value.pixmap;
	} else if (dest->clip_mask != None &&
		   src->clip_mask == None) {
	    ckfree(dest->clip_mask);
	    dest->clip_mask = None;
	} else if (dest->clip_mask != None &&
		   src->clip_mask != None) {
	    ((TkpClipMask *) dest->clip_mask)->value.pixmap =
		((TkpClipMask *) src->clip_mask)->value.pixmap;
	}
    }
    return 1;
}

Cursor
XCreateGlyphCursor(Display *display, Font source_font, Font mask_font,
		   unsigned int source_char, unsigned int mask_char,
		   XColor *foreground_color, XColor *background_color)
{
    _Cursor *_c = (_Cursor *) ckalloc(sizeof (_Cursor));

    _c->whatever = 4321;
    display->request++;
    return (Cursor) _c;
}

XIC
XCreateIC(void)
{
    return NULL;
}

XImage *
XCreateImage(Display *display, Visual *visual, unsigned int depth,
	     int format, int offset, char *data,
	     unsigned int width, unsigned int height,
	     int bitmap_pad, int bytes_per_line)
{
    XImage *ximage = (XImage *) ckalloc(sizeof (XImage));

    display->request++;

    ximage->height = height;
    ximage->width = width;
    ximage->depth = depth;
    ximage->xoffset = offset;
    ximage->format = format;
    ximage->data = data;
    ximage->bitmap_pad = bitmap_pad;
    if (bytes_per_line == 0) {
	if (depth == 8) {
	    ximage->bytes_per_line = width;
	} else {
	    ximage->bytes_per_line =
		width * SdlTk_sdlsurf->format->BytesPerPixel;
	}
    } else {
	ximage->bytes_per_line = bytes_per_line;
    }

    if (format == ZPixmap) {
	if (depth == 8) {
	    ximage->bits_per_pixel = 8;
	    ximage->bitmap_unit = 8;
	} else {
	    ximage->bits_per_pixel = SdlTk_sdlsurf->format->BitsPerPixel;
	    ximage->bitmap_unit = SdlTk_sdlsurf->format->BitsPerPixel;
	}
    } else {
	ximage->bits_per_pixel = 1;
	ximage->bitmap_unit = 8;
    }
    ximage->byte_order = LSBFirst;
    ximage->bitmap_bit_order = LSBFirst;
    ximage->red_mask = visual->red_mask;
    ximage->green_mask = visual->green_mask;
    ximage->blue_mask = visual->blue_mask;

    ximage->obdata = NULL;
    ximage->f.destroy_image = SdlTkImageDestroy;
    ximage->f.get_pixel = SdlTkImageGetPixel;
    ximage->f.put_pixel = SdlTkImagePutPixel;
    ximage->f.sub_image = NULL;
    ximage->f.add_pixel = NULL;

    return ximage;
}

Pixmap
XCreatePixmap(Display *display, Drawable d, unsigned int width,
	      unsigned int height, unsigned int depth)
{
    _Pixmap *_p;
    SDL_Surface *sdl;

    display->request++;

    if (depth == 8) {
	sdl = SDL_CreateRGBSurface(SDL_SWSURFACE, width, height,
	    8, 0, 0, 0, 0);
	if (sdl != NULL) {
	    int i;
	    SDL_Palette *pal = SDL_AllocPalette(256);
	    SDL_Color graymap[256];

	    for (i = 0; i < 256; i++) {
		graymap[i].r = graymap[i].b = graymap[i].g = i;
		graymap[i].a = 255;
	    }
	    SDL_SetPaletteColors(pal, graymap, 0, 256);
	    SDL_SetSurfacePalette(sdl, pal);
	    SDL_FreePalette(pal);
	}
    } else {
	sdl = SDL_CreateRGBSurface(SDL_SWSURFACE, width, height,
	    (depth == 1) ? depth : SdlTk_sdlsurf->format->BitsPerPixel,
	    SdlTk_sdlsurf->format->Rmask, SdlTk_sdlsurf->format->Gmask,
	    SdlTk_sdlsurf->format->Bmask, SdlTk_sdlsurf->format->Amask);
    }
    if (sdl == NULL) {
	return None;
    }

    _p = (_Pixmap *) ckalloc(sizeof (_Pixmap));
    memset(_p, '\0', sizeof (_Pixmap));
    _p->type = DT_PIXMAP;
    _p->sdl = sdl;
    _p->format = SdlTkPixelFormat(sdl);
    return (Pixmap) _p;
}

Cursor
XCreatePixmapCursor(Display *display, Pixmap source, Pixmap mask,
		    XColor *foreground_color, XColor *background_color,
		    unsigned int x, unsigned int y)
{
    return (Cursor) NULL;
}

#if 0
Region XCreateRegion(void)
{
    return None;
}
#endif

Window
XCreateWindow(Display *display, Window parent, int x, int y,
	      unsigned int width, unsigned int height,
	      unsigned int border_width, int depth, unsigned int clazz,
	      Visual *visual, unsigned long valuemask,
	      XSetWindowAttributes *attributes)
{
    _Window *_parent = (_Window *) parent;
    _Window *_w;

    display->request++;

    _w = (_Window *) ckalloc(sizeof (_Window));
    memset(_w, '\0', sizeof (_Window));

    _w->type = DT_WINDOW;
    _w->parent = (_Window *) parent;
    _w->atts.x = x;
    _w->atts.y = y;
    _w->atts.width = width;
    _w->atts.height = height;
    _w->atts.border_width = border_width;
    _w->atts.visual = visual;
    _w->atts.map_state = IsUnmapped;
    _w->atts.override_redirect = attributes ?
	attributes->override_redirect : False;
    _w->atts.your_event_mask = attributes ? attributes->event_mask : 0;

    /* A window's requested width/height are *inside* its borders.
     * It doesn't look like Tk uses this border_width anywhere, it is
     * different than the -borderwidth option. */
    _w->parentWidth = width + 2 * border_width;
    _w->parentHeight = height + 2 * border_width;

    _w->visRgn = SdlTkRgnPoolGet();
    _w->visRgnInParent = SdlTkRgnPoolGet();
    _w->dirtyRgn = SdlTkRgnPoolGet();

    _w->clazz = (clazz == InputOnly) ? InputOnly : InputOutput;

    /* Make first child of parent */
    _w->next = _parent->child;
    _parent->child = _w;

    if (_parent->atts.your_event_mask & SubstructureNotifyMask) {
	/* Make CreateNotify */
	XEvent event;

	event.type = CreateNotify;
	event.xcreatewindow.serial = display->request;
	event.xcreatewindow.send_event = False;
	event.xcreatewindow.display = display;
	event.xcreatewindow.parent = parent;
	event.xcreatewindow.window = (Window) _w;
	event.xcreatewindow.x = _w->atts.x;
	event.xcreatewindow.y = _w->atts.y;
	event.xcreatewindow.width = _w->atts.width;
	event.xcreatewindow.height = _w->atts.height;
	event.xcreatewindow.border_width = _w->atts.border_width;
	event.xcreatewindow.override_redirect = _w->atts.override_redirect;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }

    return (Window) _w;
}

#if 0
int
XDefineCursor(Display *display, Window w, Cursor c)
{
    return 0;
}
#endif

void
XDeleteProperty(Display *display, Window w, Atom property)
{
    _Window *_w = (_Window *) w;

    if (property == XA_WM_TRANSIENT_FOR) {
	_w->master = NULL;
    }
}

void
XDestroyIC(XIC ic)
{
}

#if 0
void
XDestroyRegion(Region r)
{
}
#endif

void
XDestroyWindow(Display *display, Window w)
{
    _Window *_w = (_Window *) w;
    _Window *wdec = (_w->parent && _w->parent->dec) ? _w->parent : NULL;
#if 0
    XEvent event;
    int doNotify = (_w->atts.your_event_mask & StructureNotifyMask) != 0;
#endif

    if (SdlTkX_focus_window == w) {
	SdlTkX_focus_window = None;
    }
    if (SdlTkX_focus_window_old == w) {
	SdlTkX_focus_window_old = None;
    }
    if (SdlTkX_focus_window_not_override == w) {
	SdlTkX_focus_window_not_override = None;
    }
    SdlTkClearPointer(_w);

    if (_w->atts.map_state != IsUnmapped)
	XUnmapWindow(display, w);

    display->request++;

    /* Destroy children recursively */
    while (_w->child != NULL)
	XDestroyWindow(display, (Window) _w->child);

    /* tkPointer.c cleanup (unless this is a decorative frame) */
    if (_w->tkwin != NULL) {
	extern void TkPointerDeadWindow(TkWindow *);

	TkPointerDeadWindow(_w->tkwin);
    }
    
    /* Remove from parent */
    SdlTkRemoveFromParent(_w);

#if 0
    if (SdlTkX_focus_window == w)
	SdlTkLostFocusWindow();
#endif

    /* Free the toplevel drawing surface */
    if (_w->sdl != NULL) {
	SDL_FreeSurface(_w->sdl);
    }

    /* Free the decorative frame record */
    if (_w->dec != NULL) {
	SdlTkDecDestroy(_w);
    }

    if (_w->title != NULL)
	ckfree((char *) _w->title);

    SdlTkRgnPoolFree(_w->visRgn);
    SdlTkRgnPoolFree(_w->visRgnInParent);
    SdlTkRgnPoolFree(_w->dirtyRgn);

    memset(_w, 0xFE, sizeof (_Window));
    ckfree((char *) _w);

    /* FIXME: Because the Window id is actually a pointer, another window
     * created later may occupy the same address as this deleted window.
     * So this DestroyNotify may be delivered to the new window.
     */

    /* I'm not sure this is needed. Tk generates its own DestroyNotify
     * events. */
#if 0
    if (doNotify) {
	event.type = DestroyNotify;
	event.xdestroywindow.serial = LastKnownRequestProcessed(display);
	event.xdestroywindow.send_event = False;
	event.xdestroywindow.display = display;
	event.xdestroywindow.event = w;
	event.xdestroywindow.window = w;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }
#endif
#if 1
    /* Destroy decorative frame */

    /*
     * Actually this shouldn't happen, since Tk reparents the wrapper
     * to the root before destroying it, and reparenting should destroy the
     * decorative frame 
     */
    if (wdec != NULL) {
	XDestroyWindow(display, (Window) wdec);
    }
#endif
    SdlTkScreenChanged();
}

void
XDrawArc(Display *display, Drawable d, GC gc, int x, int y,
	 unsigned int width, unsigned int height, int start, int extent)
{
    display->request++;

    SdlTkGfxDrawArc(d, gc, x, y, width, height, start, extent);

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XDrawArcs(Display *display, Drawable d, GC gc, XArc *arcs, int narcs)
{
    int n;

    display->request++;

    for (n = 0; n < narcs; n++) {
	SdlTkGfxDrawArc(d, gc, arcs[n].x, arcs[n].y,
			arcs[n].width, arcs[n].height, arcs[n].angle1,
			arcs[n].angle2);
    }

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XDrawLine(Display *display, Drawable d, GC gc, int x1, int y1, int x2, int y2)
{
    XPoint points[2];

    points[0].x = x1;
    points[0].y = y1;
    points[1].x = x2;
    points[1].y = y2;
    XDrawLines(display, d, gc, points, 2, CoordModeOrigin);
}

void
XDrawLines(Display *display, Drawable d, GC gc, XPoint *points,
	   int npoints, int mode)
{
    display->request++;

    SdlTkGfxDrawLines(d, gc, points, npoints, mode);

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XDrawPoint(Display *display, Drawable d, GC gc, int x, int y)
{
    display->request++;

    SdlTkGfxDrawPoint(d, gc, x, y);
}

void
XDrawPoints(Display *display, Drawable d, GC gc, XPoint *points, int npoints,
	    int mode)
{
    int n, x, y;

    display->request++;

    for (n = 0; n < npoints; n++) {
	if (n == 0 || mode == CoordModeOrigin) {
	    x = points[n].x;
	    y = points[n].y;
	} else {
	    x += points[n].x;
	    y += points[n].y;
	}
	SdlTkGfxDrawPoint(d, gc, x, y);
    }

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XDrawRectangle(Display *display, Drawable d, GC gc, int x, int y,
	       unsigned int width, unsigned int height)
{
    display->request++;

    SdlTkGfxDrawRect(d, gc, x, y, width, height);

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XDrawRectangles(Display *display, Drawable d, GC gc, XRectangle rects[],
		int nrects)
{
    int n;

    display->request++;

    for (n = 0; n < nrects; n++) {
	SdlTkGfxDrawRect(d, gc, rects[n].x, rects[n].y, rects[n].width,
			 rects[n].height);
    }

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XDrawSegments(Display *display, Drawable d, GC gc, XSegment *segs, int nsegs)
{
    int n;
    XPoint points[2];

    display->request++;

    for (n = 0; n < nsegs; n++) {
	points[0].x = segs[n].x1;
	points[0].y = segs[n].y1;
	points[1].x = segs[n].x2;
	points[1].y = segs[n].y2;
	SdlTkGfxDrawLines(d, gc, points, 2, CoordModeOrigin);
    }

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

int
XDrawString(Display *display, Drawable d, GC gc, int x, int y,
	    _Xconst char *string, int length)
{
    display->request++;

    SdlTkGfxDrawString(d, gc, x, y, string, length);

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }

    return 0;
}

int
XDrawString16(Display *display, Drawable d, GC gc, int x, int y,
	      const XChar2b *string, int length)
{
    display->request++;

    SdlTkGfxDrawString(d, gc, x, y, (char *) string, length);

    return 0;
}

#if 0
int
XEmptyRegion(Region r)
{
    return 0;
}
#endif

int
XEventsQueued(Display *display, int mode)
{
    return display->qlen;
}

void
XFillArc(Display *display, Drawable d, GC gc, int x, int y,
	 unsigned int width, unsigned int height, int start, int extent)
{
    display->request++;

    SdlTkGfxFillArc(d, gc, x, y, width, height, start, extent);

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XFillArcs(Display *display, Drawable d, GC gc, XArc *arcs, int narcs)
{
    int n;

    display->request++;

    for (n = 0; n < narcs; n++) {
	SdlTkGfxFillArc(d, gc, arcs[n].x, arcs[n].y,
			arcs[n].width, arcs[n].height, arcs[n].angle1,
			arcs[n].angle2);
    }

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XFillPolygon(Display *display, Drawable d, GC gc, XPoint *points,
	     int npoints, int shape, int mode)
{
    display->request++;

    SdlTkGfxFillPolygon(d, gc, points, npoints, shape, mode);

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

void
XFillRectangle(Display *display, Drawable d, GC gc, int x, int y,
	       unsigned int width, unsigned int height)
{
    XRectangle rectangle;
    rectangle.x = x;
    rectangle.y = y;
    rectangle.width = width;
    rectangle.height = height;
    XFillRectangles(display, d, gc, &rectangle, 1);
}

void
XFillRectangles(Display *display, Drawable d, GC gc,
		XRectangle *rectangles, int nrectangles)
{
    int i;

    display->request++;

    for (i = 0; i < nrectangles; i++) {
	SdlTkGfxFillRect(d, gc, rectangles[i].x, rectangles[i].y,
	    rectangles[i].width, rectangles[i].height);
    }

    if (IS_WINDOW(d)) {
	SdlTkScreenChanged();
	SdlTkDirtyAll(d);
    }
}

Bool
XFilterEvent(XEvent *event, Window window)
{
    return 0;
}

int
XFlush(Display *display)
{
    SDL_Event sdl_event;
    XEvent event;
    _XSQEvent *qevent;
    extern int SdlTkX_drag_lock;

    display->request++;

    if (SdlTkX_drag_lock) return 0;

    memset(&sdl_event, 0, sizeof (sdl_event));
    memset(&event, 0, sizeof (event));

    /* Add all pending SDL events to the X event queue */
    while (SDL_PollEvent(&sdl_event)) {

	if (!SdlTkTranslateEvent(&sdl_event, &event)) {
	    continue;
	}

	/* Grab an unused event from the list */
	qevent = display->qfree;
	if (qevent == NULL) {
	    qevent = (_XSQEvent *) ckalloc(sizeof (_XSQEvent));
	} else {
	    display->qfree = display->qfree->next;
	}

	qevent->sdl_event = sdl_event;
	qevent->event = event;
	qevent->next = NULL;

	/* Append to event queue */
	if (display->tail)
	    display->tail->next = qevent;
	else
	    display->head = qevent;
	display->tail = qevent;

	display->qlen++;
    }

    return 0;
}

void
XForceScreenSaver(Display *display, int mode)
{
}

int
XFree(void *data)
{
    if (data != NULL) {
	ckfree(data);
    }
    return 0;
}

void
XFreeColormap(Display *display, Colormap colormap)
{
}

void
XFreeColors(Display *display, Colormap colormap, unsigned long *pixels,
	    int npixels, unsigned long planes)
{
}

void
XFreeCursor(Display *display, Cursor cursor)
{
}

/* "The XFreeFont() function deletes the association between the font resource
ID and the specified font and frees the XFontStruct structure. The font itself
will be freed when no other resource references it. The data and the font
should not be referenced again." */

int
XFreeFont(Display *display, XFontStruct *font_struct)
{
    SdlTkFontFreeFont(font_struct);
    return 0;
}

int
XFreeFontNames(char **list)
{
    int i = 0;

    if (list == NULL)
	return 0;
    while (list[i] != NULL)
	ckfree(list[i++]);
    ckfree((char *) list);
    return 0;
}

void
XFreeGC(Display *display, GC gc)
{
    display->request++;

    if (gc != None) {
	if (gc->clip_mask != None) {
	    ckfree((char*) gc->clip_mask);
	}
	memset(gc, 0xFE, sizeof (GC));
	ckfree((char *) gc);
    }
}

void
XFreeModifiermap(XModifierKeymap *modmap)
{
    ckfree((char *) modmap->modifiermap);
    ckfree((char *) modmap);
}

int
XFreePixmap(Display *display, Pixmap pixmap)
{
    _Pixmap *_p = (_Pixmap *) pixmap;

    display->request++;

    if (_p == NULL)
	return 0;
    SDL_FreeSurface(_p->sdl);
    memset(_p, 0xFE, sizeof (_Pixmap));
    ckfree((char *) _p);
    return 0;
}

GContext
XGContextFromGC(GC gc)
{
    return (GContext) NULL;
}

char *
XGetAtomName(Display *display, Atom atom)
{
    char *ret = NULL;

    if (atom != None) {
	int len = strlen((char *) atom) + 1;
	ret = ckalloc(len);
	strcpy(ret, (char *) atom);
    }
    return ret;
}

Bool
XGetFontProperty(XFontStruct *font_struct, Atom atom,
		 unsigned long *value_return)
{
    if (atom == XA_FONT) {
	_Font *_f = (_Font *) font_struct->fid;
	*value_return = (unsigned long) XInternAtom(NULL, _f->xlfd, False);
	return True;
    }
    return False;
}

Status
XGetGeometry(Display *display, Drawable d, Window *root_return,
	     int *x_return, int *y_return, unsigned int *width_return,
	     unsigned int *height_return, unsigned int *border_width_return,
	     unsigned int *depth_return)
{
    _Pixmap *_p = (_Pixmap *) d;
    _Window *_w = (_Window *) d;

    display->request++;

    *root_return = SdlTkX_screen->root;
    
    if (_p->type == DT_PIXMAP) {
	*x_return = *y_return = 0;
	*width_return = _p->sdl->w;
	*height_return = _p->sdl->h;
	*border_width_return = 0;
	*depth_return = _p->sdl->format->BitsPerPixel;
    }
    if (_w->type == DT_WINDOW) {
	*x_return = _w->atts.x;
	*y_return = _w->atts.y;
	*width_return = _w->atts.width;
	*height_return = _w->atts.height;
	*border_width_return = _w->atts.border_width;
	*depth_return = SdlTkX_screen->root_depth;
    }
    
    return 1;
}

XImage *
XGetImage(Display *display, Drawable d, int x, int y,
	  unsigned int width, unsigned int height, unsigned long plane_mask,
	  int format)
{
    SDL_Surface *sdl;
    char *pixels;
    _Pixmap *_p = (_Pixmap *) d;
    _Pixmap rp;
    int bpp;
    XGCValues fakeGC;

    if (_p->type == DT_PIXMAP) {
	/* Allocate a block of pixels to hold the result. */
	pixels = ckalloc(width * height * _p->sdl->format->BytesPerPixel);

	/* Create an SDL surface that uses the pixels we allocated above */
	sdl = SDL_CreateRGBSurfaceFrom(pixels, width, height,
	    _p->sdl->format->BitsPerPixel,
	    width * _p->sdl->format->BytesPerPixel, /* pitch */
	    _p->sdl->format->Rmask, _p->sdl->format->Gmask,
	    _p->sdl->format->Bmask, _p->sdl->format->Amask);
	bpp = _p->sdl->format->BitsPerPixel;
	if (bpp == 8 && sdl != NULL) {
	    int i;
	    SDL_Palette *pal = SDL_AllocPalette(256);
	    SDL_Color graymap[256];

	    for (i = 0; i < 256; i++) {
		graymap[i].r = graymap[i].b = graymap[i].g = i;
		graymap[i].a = 255;
	    }
	    SDL_SetPaletteColors(pal, graymap, 0, 256);
	    SDL_SetSurfacePalette(sdl, pal);
	    SDL_FreePalette(pal);
	}
    } else {
	/* Allocate a block of pixels to hold the result. */
	pixels = ckalloc(width * height * SdlTk_sdlsurf->format->BytesPerPixel);

	/* Create an SDL surface that uses the pixels we allocated above */
	sdl = SDL_CreateRGBSurfaceFrom(pixels, width, height,
	    SdlTk_sdlsurf->format->BitsPerPixel,
	    width * SdlTk_sdlsurf->format->BytesPerPixel, /* pitch */
	    SdlTk_sdlsurf->format->Rmask, SdlTk_sdlsurf->format->Gmask,
	    SdlTk_sdlsurf->format->Bmask, SdlTk_sdlsurf->format->Amask);
	bpp = SdlTk_sdlsurf->format->BitsPerPixel;
    }

    if (sdl == NULL) {
	ckfree(pixels);
	return NULL;
    }

    /* Create a pixmap from the SDL surface. */
    rp.type = DT_PIXMAP;
    rp.sdl = sdl;
    rp.format = SdlTkPixelFormat(sdl);

    fakeGC.clip_mask = None;
    fakeGC.graphics_exposures = False;

    /* Copy from the drawable to our pixmap */
    SdlTkGfxCopyArea(d, (Pixmap) &rp, &fakeGC, x, y, width, height, 0, 0);

    /* Free the surface. The pixels are *not* freed */
    SDL_FreeSurface(sdl);

    /* Allocate the XImage using the pixels we allocated above */ 
    return XCreateImage(display, SdlTkX_screen->root_visual,
	bpp, ZPixmap, 0, pixels, width, height, 0, 0);
}

int
XGetInputFocus(Display *display, Window *focus_return, int *revert_to_return)
{
    display->request++;
    *focus_return = SdlTkX_focus_window;
    *revert_to_return = RevertToParent;
    return 0;
}

XModifierKeymap	*
XGetModifierMapping(Display *display)
{
    XModifierKeymap *map;

    map = (XModifierKeymap *)ckalloc(sizeof (XModifierKeymap));

    map->max_keypermod = 2;
    map->modifiermap = (KeyCode *) ckalloc(sizeof (KeyCode) * 16);
    memset(map->modifiermap, 0, sizeof (KeyCode) * 16);
    map->modifiermap[ShiftMapIndex * 2 + 0] = SDL_SCANCODE_LSHIFT;
    map->modifiermap[ShiftMapIndex * 2 + 1] = SDL_SCANCODE_RSHIFT;
    map->modifiermap[LockMapIndex * 2 + 0] = SDL_SCANCODE_CAPSLOCK;
    map->modifiermap[ControlMapIndex * 2 + 0] = SDL_SCANCODE_LCTRL;
    map->modifiermap[ControlMapIndex * 2 + 1] = SDL_SCANCODE_RCTRL;
    map->modifiermap[Mod1MapIndex * 2 + 0] = SDL_SCANCODE_LALT;
    map->modifiermap[Mod2MapIndex * 2 + 0] = SDL_SCANCODE_NUMLOCKCLEAR;
    map->modifiermap[Mod3MapIndex * 2 + 0] = SDL_SCANCODE_SCROLLLOCK;
    return map;
}

int
XGetWindowAttributes(Display *display, Window w,
		     XWindowAttributes *window_attributes_return)
{
    if (window_attributes_return != NULL) {
	_Window *_w = (_Window *) w;

	*window_attributes_return = _w->atts;
	return 1;
    }
    return 0;
}

int
XGetWindowProperty(Display *display, Window w, Atom property,
		   long long_offset, long long_length, Bool delete,
		   Atom req_type, Atom *actual_type_return,
		   int *actual_format_return, unsigned long *nitems_return,
		   unsigned long *bytes_after_return,
		   unsigned char **prop_return)
{
    *actual_type_return = None;
    *actual_format_return = 0;
    *nitems_return = 0;
    *bytes_after_return = 0;
    *prop_return = NULL;
    if (property == nwms_atom) {
	_Window *_w = (_Window *) w;

	if (_w->fullscreen) {
	    *prop_return = (unsigned char *) ckalloc(sizeof (Atom));
	    ((Atom *) *prop_return)[0] = nwmsf_atom;
	    *nitems_return = 1;
	}
	return Success;
    }
    return BadValue;
}

XVisualInfo *
XGetVisualInfo(Display *display, long vinfo_mask, XVisualInfo *vinfo_template,
	       int *nitems_return)
{
    XVisualInfo *info = (XVisualInfo *)ckalloc(sizeof (XVisualInfo));

    memset(info, '\0', sizeof (XVisualInfo));
    info->visual = DefaultVisual(display, 0);
    info->visualid = info->visual->visualid;
    info->screen = 0;
    info->depth = info->visual->bits_per_rgb;
    info->class = info->visual->class;
    info->colormap_size = info->visual->map_entries;
    info->bits_per_rgb = info->visual->bits_per_rgb;
    info->red_mask = info->visual->red_mask;
    info->green_mask = info->visual->green_mask;
    info->blue_mask = info->visual->blue_mask;
    
    if (((vinfo_mask & VisualIDMask)
	    && (vinfo_template->visualid != info->visualid))
	    || ((vinfo_mask & VisualScreenMask)
		    && (vinfo_template->screen != info->screen))
	    || ((vinfo_mask & VisualDepthMask)
		    && (vinfo_template->depth != info->depth))
	    || ((vinfo_mask & VisualClassMask)
		    && (vinfo_template->class != info->class))
	    || ((vinfo_mask & VisualColormapSizeMask)
		    && (vinfo_template->colormap_size != info->colormap_size))
	    || ((vinfo_mask & VisualBitsPerRGBMask)
		    && (vinfo_template->bits_per_rgb != info->bits_per_rgb))
	    || ((vinfo_mask & VisualRedMaskMask)
		    && (vinfo_template->red_mask != info->red_mask))
	    || ((vinfo_mask & VisualGreenMaskMask)
		    && (vinfo_template->green_mask != info->green_mask))
	    || ((vinfo_mask & VisualBlueMaskMask)
		    && (vinfo_template->blue_mask != info->blue_mask))
	) {
	ckfree((char *) info);
	return NULL;
    }

    *nitems_return = 1;
    return info;
}

Status
XGetWMColormapWindows(Display *display, Window w, Window **windows_return,
		      int *count_return)
{
    return (Status) 0;
}

int
XGrabKeyboard(Display *display, Window grab_window, Bool owner_events,
	      int pointer_mode, int keyboard_mode, Time time)
{
    return GrabSuccess;
}

#if 0
int
XGrabPointer(Display *display, Window w1, Bool b, unsigned int ui,
	     int i1, int i2, Window w2, Cursor c, Time t)
{
    return 0;
}
#endif

int
XGrabServer(Display *display)
{
    return 0;
}

int
XIconifyWindow(Display *display, Window w, int screen_number)
{
    return 0;
}

Atom
XInternAtom(Display *display, _Xconst char *atom_name, Bool only_if_exists)
{
    static int initialized = 0;
    static Tcl_HashTable atomTable;
    Tcl_HashEntry *hPtr;

    if (!initialized) {
	Tcl_InitHashTable(&atomTable, TCL_STRING_KEYS);
	initialized = 1;
    }
    if (only_if_exists) {
	hPtr = Tcl_FindHashEntry(&atomTable, (char *) atom_name);
    } else {
	int new;

	hPtr = Tcl_CreateHashEntry(&atomTable, (char *) atom_name, &new);
	if (new) {
	    Tcl_SetHashValue(hPtr, Tcl_GetHashKey(&atomTable, hPtr));
	}
    }
    if (hPtr == NULL) {
	return None;
    }
    if (strcmp(atom_name, "_MOTIF_WM_HINTS") == 0) {
	mwm_atom = (Atom) Tcl_GetHashValue(hPtr);
    } else if (strcmp(atom_name, "_NET_WM_STATE") == 0) {
	nwms_atom = (Atom) Tcl_GetHashValue(hPtr);
    } else if (strcmp(atom_name, "_NET_WM_STATE_FULLSCREEN") == 0) {
	nwmsf_atom = (Atom) Tcl_GetHashValue(hPtr);
    } else if (strcmp(atom_name, "CLIPBOARD") == 0) {
	clipboard = (Atom) Tcl_GetHashValue(hPtr);
    }
    return (Atom) Tcl_GetHashValue(hPtr);
}

KeySym
XKeycodeToKeysym(Display *display, unsigned int keycode, int index)
{
    /* keycode is SDL_SCANCODE_xxx */
    static int keymap_init = 0;
    static KeySym keymap[SDL_NUM_SCANCODES];
    int i;

    if (!keymap_init) {
	for (i = 0; i < SDL_NUM_SCANCODES; i++) {
	    keymap[i] = NoSymbol;
	}

	for (i = 0; i < 26; i++) {
	    keymap[SDL_SCANCODE_A + i] = XK_a + i;
	}

	keymap[SDL_SCANCODE_SPACE] = XK_space;
	keymap[SDL_SCANCODE_KP_EXCLAM] = XK_exclam;
	//keymap[SDL_SCANCODE_QUOTEDBL] = XK_quotedbl;
	keymap[SDL_SCANCODE_KP_HASH] = XK_numbersign;
	//keymap[SDL_SCANCODE_DOLLAR] = XK_dollar;
	keymap[SDL_SCANCODE_KP_PERCENT] = XK_percent;
	keymap[SDL_SCANCODE_KP_AMPERSAND] = XK_ampersand;
	//keymap[SDL_SCANCODE_QUOTE] = XK_apostrophe;
	keymap[SDL_SCANCODE_KP_LEFTPAREN] = XK_parenleft;
	keymap[SDL_SCANCODE_KP_RIGHTPAREN] = XK_parenright;
	//keymap[SDL_SCANCODE_ASTERISK] = XK_asterisk;
	keymap[SDL_SCANCODE_KP_PLUS] = XK_plus;
	keymap[SDL_SCANCODE_COMMA] = XK_comma;
	keymap[SDL_SCANCODE_MINUS] = XK_minus;
	keymap[SDL_SCANCODE_PERIOD] = XK_period;
	keymap[SDL_SCANCODE_SLASH] = XK_slash;

	for (i = 0; i <= 9; i++) {
	    keymap[SDL_SCANCODE_0 + i] = XK_0 + i;
	}

	keymap[SDL_SCANCODE_KP_COLON] = XK_colon;
	keymap[SDL_SCANCODE_SEMICOLON] = XK_semicolon;
	keymap[SDL_SCANCODE_KP_LESS] = XK_less;
	keymap[SDL_SCANCODE_EQUALS] = XK_equal;
	keymap[SDL_SCANCODE_KP_GREATER] = XK_greater;
	//keymap[SDL_SCANCODE_QUESTION] = XK_question;
	keymap[SDL_SCANCODE_KP_AT] = XK_at;

	keymap[SDL_SCANCODE_LEFTBRACKET] = XK_bracketleft;
	keymap[SDL_SCANCODE_BACKSLASH] = XK_backslash;
	keymap[SDL_SCANCODE_RIGHTBRACKET] = XK_bracketright;
	//keymap[SDL_SCANCODE_CARET] = XK_asciicircum;
	//keymap[SDL_SCANCODE_UNDERSCORE] = XK_underscore;
	//keymap[SDL_SCANCODE_BACKQUOTE] = XK_grave;

	keymap[SDL_SCANCODE_KP_0] = XK_KP_0;
	keymap[SDL_SCANCODE_KP_1] = XK_KP_1;
	keymap[SDL_SCANCODE_KP_2] = XK_KP_2;
	keymap[SDL_SCANCODE_KP_3] = XK_KP_3;
	keymap[SDL_SCANCODE_KP_4] = XK_KP_4;
	keymap[SDL_SCANCODE_KP_5] = XK_KP_5;
	keymap[SDL_SCANCODE_KP_6] = XK_KP_6;
	keymap[SDL_SCANCODE_KP_7] = XK_KP_7;
	keymap[SDL_SCANCODE_KP_8] = XK_KP_8;
	keymap[SDL_SCANCODE_KP_9] = XK_KP_9;

	keymap[SDL_SCANCODE_KP_PERIOD] = XK_KP_Decimal;
	keymap[SDL_SCANCODE_KP_DIVIDE] = XK_KP_Divide;
	keymap[SDL_SCANCODE_KP_MULTIPLY] = XK_KP_Multiply;
	keymap[SDL_SCANCODE_KP_MINUS] = XK_KP_Subtract;
	keymap[SDL_SCANCODE_KP_PLUS] = XK_KP_Add;
	keymap[SDL_SCANCODE_KP_ENTER] = XK_KP_Enter;
	keymap[SDL_SCANCODE_KP_EQUALS] = XK_KP_Equal;

	keymap[SDL_SCANCODE_LGUI] = XK_Win_L;
	keymap[SDL_SCANCODE_RGUI] = XK_Win_R;
	keymap[SDL_SCANCODE_MENU] = XK_App;

	keymap[SDL_SCANCODE_BACKSPACE] = XK_BackSpace;
	keymap[SDL_SCANCODE_DELETE] = XK_Delete;
	keymap[SDL_SCANCODE_TAB] = XK_Tab;
	keymap[SDL_SCANCODE_RETURN] = XK_Return;
	keymap[SDL_SCANCODE_LALT] = XK_Alt_L;
	keymap[SDL_SCANCODE_LCTRL] = XK_Control_L;
	keymap[SDL_SCANCODE_LSHIFT] = XK_Shift_L;
#ifndef XK_ISO_Level3_Shift
#define XK_ISO_Level3_Shift 0xFE03
#endif
	keymap[SDL_SCANCODE_RALT] = XK_ISO_Level3_Shift;
	keymap[SDL_SCANCODE_RCTRL] = XK_Control_R;
	keymap[SDL_SCANCODE_RSHIFT] = XK_Shift_R;
	keymap[SDL_SCANCODE_PAUSE] = XK_Pause;
	keymap[SDL_SCANCODE_ESCAPE] = XK_Escape;
	keymap[SDL_SCANCODE_PAGEUP] = XK_Prior;
	keymap[SDL_SCANCODE_PAGEDOWN] = XK_Next;
	keymap[SDL_SCANCODE_END] = XK_End;
	keymap[SDL_SCANCODE_HOME] = XK_Home;
	keymap[SDL_SCANCODE_LEFT] = XK_Left;
	keymap[SDL_SCANCODE_RIGHT] = XK_Right;
	keymap[SDL_SCANCODE_UP] = XK_Up;
	keymap[SDL_SCANCODE_DOWN] = XK_Down;
	keymap[SDL_SCANCODE_INSERT] = XK_Insert;

	for (i = 0; i < 12; i++) {
	    keymap[SDL_SCANCODE_F1 + i] = XK_F1 + i;
	}

	keymap[SDL_SCANCODE_CAPSLOCK] = XK_Caps_Lock;
	keymap[SDL_SCANCODE_NUMLOCKCLEAR] = XK_Num_Lock;
	keymap[SDL_SCANCODE_SCROLLLOCK] = XK_Scroll_Lock;

	keymap_init = 1;
    }

    if (keycode < 0 || keycode >= SDL_NUM_SCANCODES) {
	return NoSymbol;
    }
    return keymap[keycode];
}

KeyCode
XKeysymToKeycode(Display *display, KeySym keysym)
{
    return 0;
}

char *
XKeysymToString(KeySym keysym)
{
    return NULL;
}

char **
XListFonts(Display *display, _Xconst char *pattern, int maxnames,
	   int *actual_count_return)
{
    return SdlTkListFonts(pattern, actual_count_return);
}

XHostAddress *
XListHosts(Display *display, int *nhosts_return, Bool *state_return)
{
    return NULL;
}

Font
XLoadFont(Display *display, _Xconst char *name)
{
    return SdlTkFontLoadXLFD(name);
}

XFontStruct *
XLoadQueryFont(Display *display, _Xconst char *name)
{
    Font f = SdlTkFontLoadXLFD(name);
    return f ? ((_Font *) f)->font_struct : NULL;
}

int
XLookupColor(Display *display, Colormap colormap, _Xconst char *color_name,
	     XColor *exact_def_return, XColor *screen_def_return)
{
    return 0;
}

/* Needed for TkpGetString */
int
XLookupString(XKeyEvent *event_struct, char *buffer_return, int bytes_buffer,
	      KeySym *keysym_return, XComposeStatus *status_in_out)
{
    /* Only care about buffer and bytes_buffer */
    /* Already converted to UTF-8 by SdlTkTranslateEvent */
    memcpy(buffer_return, event_struct->trans_chars, event_struct->nbytes);
    return event_struct->nbytes; /* length */
}

/*
 *----------------------------------------------------------------------
 *
 * NotifyVisibility --
 *
 *      This function recursively notifies the mapped children of the
 *      specified window of a change in visibility.  Note that we don't
 *      properly report the visibility state, since Windows does not
 *      provide that info.  The eventPtr argument must point to an event
 *      that has been completely initialized except for the window slot.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      Generates lots of events.
 *
 *----------------------------------------------------------------------
 */

static void
NotifyVisibility(XEvent *eventPtr, Window w)
{
    _Window *_w = (_Window *) w;

    if (_w->atts.your_event_mask & VisibilityChangeMask) {
        eventPtr->xvisibility.window = w;
        Tk_QueueWindowEvent(eventPtr, TCL_QUEUE_TAIL);
    }
    for (_w = _w->child; _w != NULL; _w = _w->next) {
        if (_w->atts.map_state != IsUnmapped) {
            NotifyVisibility(eventPtr, (Window) _w);
        }
    }
}

void
XMapWindow(Display *display, Window w)
{
    _Window *_w = (_Window *) w;
    XEvent event;
    int doconf = 0;

    display->request++;

    if (_w->atts.map_state != IsUnmapped)
	return;

    if (_w->fullscreen) {
	if (_w->atts.width != SdlTk_sdlsurf->w ||
	    _w->atts.height != SdlTk_sdlsurf->h) {
	    _w->atts_saved = _w->atts;
	    _w->atts.width = SdlTk_sdlsurf->w;
	    _w->atts.height = SdlTk_sdlsurf->h;
	    if (_w->parent != NULL && _w->parent->dec != NULL) {
		_Window *_p = _w->parent;

		_w->atts.x = DEC_FRAME_WIDTH;
		_w->atts.y = DEC_TITLE_HEIGHT;
		_p->atts.width = _w->atts.width + 2 * DEC_FRAME_WIDTH;
		_p->atts.height = _w->atts.width + DEC_FRAME_WIDTH +
				  DEC_TITLE_HEIGHT;
		_p->atts.x = -DEC_FRAME_WIDTH;
		_p->atts.y = -DEC_TITLE_HEIGHT;
	    } else {
		_w->atts.x = _w->atts.y = 0;
	    }
	    doconf = 1;
	}
    }

    /*
     * A reparenting window manager like twm will get a MapRequest event
     * when XMapWindow is called. It will then create a decorative frame
     * window to contain the window, and reparent the window inside the
     * decorative frame.
     */
    if (PARENT_IS_ROOT(w) &&
	    (_w->tkwin != NULL) &&
	    !_w->atts.override_redirect &&
	    (_w->dec == NULL)) {
	Window wdec;
	int x, y, width, height;

	/*
	 * Each reparent gets a drawing surface for itself and all its
	 * children.
	 */
	x = _w->atts.x;
	y = _w->atts.y;
	width = _w->atts.width + DEC_FRAME_WIDTH * 2;
	height = _w->atts.height + DEC_TITLE_HEIGHT + DEC_FRAME_WIDTH;
	if (_w->fullscreen) {
	    x -= DEC_FRAME_WIDTH;
	    y -= DEC_TITLE_HEIGHT;
	}

	wdec = XCreateWindow(display, SdlTkX_screen->root,
	    x, y, width, height, 0, SdlTkX_screen->root_depth, InputOutput,
	    SdlTkX_screen->root_visual, 0, NULL);

	SdlTkDecCreate((_Window *) wdec);

	/* Reparent the window into the decorative frame, and move it
	 * to the proper place */
	XReparentWindow(display, w, wdec, DEC_FRAME_WIDTH, DEC_TITLE_HEIGHT);

	/* Let Tk know I moved the window. You would think the <Reparent>
	 * event would be a good clue */
	if (_w->atts.your_event_mask & StructureNotifyMask)
	    SdlTkGenerateConfigureNotify(display, w);
    } else if (doconf) {
	SdlTkGenerateConfigureNotify(display, w);
    }

    /* Map decorative frame */
    if (_w->parent != NULL && _w->parent->dec != NULL) {
	_w->parent->atts.map_state = IsViewable;
    }

    _w->atts.map_state = IsViewable;

    /* Tk only cares about this for wrapper windows */
    if (_w->atts.your_event_mask & StructureNotifyMask) {
	event.type = MapNotify;
	event.xmap.serial = display->request;
	event.xmap.send_event = False;
	event.xmap.display = display;
	event.xmap.event = w;
	event.xmap.window = w;
	event.xmap.override_redirect = _w->atts.override_redirect;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkVisRgnChanged(_w->parent, VRC_CHANGED | VRC_DO_PARENT, 0, 0);
    else
	SdlTkVisRgnChanged(_w, VRC_CHANGED | VRC_DO_PARENT, 0, 0);

    /* Generate a <FocusIn> if this is the top-most Tk wrapper window */
    /* Don't focus on override_redirect's though (i.e., menus) */
    if (_w == SdlTkTopVisibleWrapper() && _w->parent != NULL &&
	_w->parent->dec != NULL)
	XSetInputFocus(display, w, RevertToParent, CurrentTime);

    SdlTkScreenChanged();

    /*
     * Generate VisibilityNotify events for this window and its mapped
     * children.
     */

    event.type = VisibilityNotify;
    event.xvisibility.serial = display->request;
    event.xvisibility.send_event = False;
    event.xvisibility.display = display;
    event.xvisibility.window = w;
    event.xvisibility.state = VisibilityUnobscured;
    NotifyVisibility(&event, w);
}

void
XRaiseWindow(Display *display, Window w)
{
    _Window *_w = (_Window *) w;

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkRestackWindow(_w->parent, NULL, Above);
    else
	SdlTkRestackWindow(_w, NULL, Above);

    /* Generate a <FocusIn> if this is the top-most Tk wrapper window */
    /* Don't focus on override_redirect's though (i.e., menus) */
    if (_w == SdlTkTopVisibleWrapper() && _w->parent != NULL &&
	_w->parent->dec != NULL)
	XSetInputFocus(display, w, RevertToParent, CurrentTime);
}

void
XLowerWindow(Display *display, Window w)
{
    _Window *_w = (_Window *) w;

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkRestackWindow(_w->parent, NULL, Below);
    else
	SdlTkRestackWindow(_w, NULL, Below);
}

void
XMoveWindow(Display *display, Window w, int x, int y)
{
    _Window *_w = (_Window *) w;
    int ox, oy;

    display->request++;

    if (_w->fullscreen) {
	if (_w->atts.your_event_mask & StructureNotifyMask) {
	    SdlTkGenerateConfigureNotify(display, w);
	}
	return;
    }

    /* If the window has a decorative frame, move the decorative frame
     * instead of the given window */
    if (_w->parent != NULL && _w->parent->dec != NULL) {
	_Window *wdec = _w->parent;
	ox = wdec->atts.x, oy = wdec->atts.y;
	wdec->atts.x = x;
	wdec->atts.y = y;
    } else {
	ox = _w->atts.x, oy = _w->atts.y;
	_w->atts.x = x;
	_w->atts.y = y;
    }

    if (_w->atts.your_event_mask & StructureNotifyMask)
	SdlTkGenerateConfigureNotify(display, w);

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkVisRgnChanged(_w->parent, VRC_CHANGED | VRC_DO_PARENT | VRC_MOVE, ox, oy);
    else
	SdlTkVisRgnChanged(_w, VRC_CHANGED | VRC_DO_PARENT | VRC_MOVE, ox, oy);

    SdlTkScreenChanged();
}

void
XMoveResizeWindow(Display *display, Window w, int x, int y,
		  unsigned int width, unsigned int height)
{
    _Window *_w = (_Window *) w;
    int ox = 0, oy = 0, flags = VRC_CHANGED | VRC_DO_PARENT;

    display->request++;

    if (_w->fullscreen) {
	if (_w->atts.your_event_mask & StructureNotifyMask) {
	    SdlTkGenerateConfigureNotify(display, w);
	}
	return;
    }

    if ((int) width < 1)
	width = 1;
    if ((int) height < 1)
	height = 1;

    /* If this window has a decorative frame, move the decorative frame,
     * not the given window */
    if (_w->parent != NULL && _w->parent->dec != NULL) {
	_Window *wdec = _w->parent;
	if (x != wdec->atts.x || y != wdec->atts.y) {
	    ox = wdec->atts.x, oy = wdec->atts.y;
	    flags |= VRC_MOVE;
	    wdec->atts.x = x;
	    wdec->atts.y = y;
	}
    } else {

	/* ConfigureEvent will call this on the children of a wrapper even if
	* their size/position doesn't change. ConfigureEvent doesn't wait
	* for <ConfigureNotify> so do nothing in this case. */
	if (x == _w->atts.x && y == _w->atts.y &&
	    width == _w->atts.width && height == _w->atts.height)
	    return;

	if (x != _w->atts.x || y != _w->atts.y) {
	    ox = _w->atts.x, oy = _w->atts.y;
	    flags |= VRC_MOVE;
	    _w->atts.x = x;
	    _w->atts.y = y;
	}
    }

    /* "wm geom +x+y will call this, even though the size doesn't change */
    if (_w->atts.width != width || _w->atts.height != height) {

	/* If this window has a decorative frame, resize it */
	if (_w->parent != NULL && _w->parent->dec != NULL) {
	    _Window *wdec = _w->parent;

	    wdec->atts.width = width + DEC_FRAME_WIDTH * 2;
	    wdec->atts.height = height + DEC_TITLE_HEIGHT + DEC_FRAME_WIDTH;

	    /* A window's requested width/height are *inside* its borders */
	    /* A child window is clipped within its parent's borders */
	    wdec->parentWidth = wdec->atts.width + 2 * wdec->atts.border_width;
	    wdec->parentHeight = wdec->atts.height + 2 * wdec->atts.border_width;
	}

	_w->atts.width = width;
	_w->atts.height = height;

	/* A window's requested width/height are *inside* its borders */
	/* A child window is clipped within its parent's borders */
	_w->parentWidth = width + 2 * _w->atts.border_width;
	_w->parentHeight = height + 2 * _w->atts.border_width;

    }

    if (_w->atts.your_event_mask & StructureNotifyMask)
	SdlTkGenerateConfigureNotify(display, w);

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkVisRgnChanged(_w->parent, flags, ox, oy);
    else
	SdlTkVisRgnChanged(_w, flags, ox, oy);

    SdlTkScreenChanged();
}

int
XNextEvent(Display *display, XEvent *event_return)
{
    _XSQEvent *qevent = display->head;

again:
    if (qevent != NULL) {
	*event_return = qevent->event;

	/* Remove from front of queue */
	display->head = qevent->next;
	if (display->head == NULL)
	    display->tail = NULL;

	/* Add to front of free list */
	qevent->next = display->qfree;
	display->qfree = qevent;

	display->qlen--;

    } else if (SDL_PollEvent(NULL)) {
	XFlush(display);
	goto again;
    }
    return 0;
}

int
XNoOp(Display *display)
{
    display->request++;
    return 0;
}

Display *
XOpenDisplay(_Xconst char *display_name)
{
    Display *display;
    Screen *screen;
    int width, height, min_w = 200, min_h = 200;
    Uint32 videoflags;
    _Window *_w;
    SDL_SysWMinfo wminfo;
    Uint32 fmt;
    SDL_DisplayMode info;
    SDL_PixelFormat *pfmt;
#ifdef ANDROID
    int initMask = SDL_INIT_VIDEO | SDL_INIT_JOYSTICK;
#else
    struct FakeXDisplay {
	char *p[2];
	int fd;
    } *fakeXDisplay;
    int initMask = SDL_INIT_VIDEO;
#endif
    XGCValues values;

    if (SdlTkX_display != NULL)
	return SdlTkX_display;

    if (SDL_Init(initMask) < 0) {
	fprintf(stderr, "Couldn't initialize SDL: %s\n", SDL_GetError());
	return NULL;
    }
#ifndef ANDROID
    atexit(SDL_Quit);
#endif
    videoflags = SDL_SWSURFACE;
#ifdef ANDROID
    videoflags |= SDL_WINDOW_FULLSCREEN;
    videoflags |= SDL_WINDOW_RESIZABLE;
    videoflags |= SDL_WINDOW_BORDERLESS;
    width = 200;
    height = 200;
#else
    if (SdlTk_arg_fullscreen)
	videoflags |= SDL_WINDOW_FULLSCREEN;
    if (SdlTk_arg_resizable)
	videoflags |= SDL_WINDOW_RESIZABLE;
    if (SdlTk_arg_noborder)
	videoflags |= SDL_WINDOW_BORDERLESS;
    width = 1024;
    height = 768;
#endif
    if (SdlTk_arg_width != NULL)
	sscanf(SdlTk_arg_width, "%d", &width);
    if (SdlTk_arg_height != NULL)
	sscanf(SdlTk_arg_height, "%d", &height);

    SDL_GetDesktopDisplayMode(0, &info);
    pfmt = SDL_AllocFormat(info.format);
    if (info.w > 0 && info.h > 0) {
	if (videoflags & SDL_WINDOW_FULLSCREEN) {
	    width = info.w;
	    height = info.h;
	}
	if (width > info.w)
	    width = info.w;
	if (height > info.h)
	    height = info.h;
	if (width <= 0)
	    width = info.w;
	if (height <= 0)
	    height = info.h;
    }
    if (SdlTk_arg_resizable) {
	if (min_w > width) {
	    min_w = width;
	}
	if (min_h > height) {
	    min_h = height;
	}
    }
    SdlTk_sdlscreen = SDL_CreateWindow("SDLWISH", SDL_WINDOWPOS_UNDEFINED,
				       SDL_WINDOWPOS_UNDEFINED, width,
				       height, videoflags);
    if (SdlTk_sdlscreen == NULL) {
	fprintf(stderr, "Couldn't create SDL window: %s\n",
		SDL_GetError());
	fflush(stderr);
	return NULL;
    }
#ifndef ANDROID
    SDL_SetWindowMinimumSize(SdlTk_sdlscreen, min_w, min_h);
#endif

    fmt = SDL_GetWindowPixelFormat(SdlTk_sdlscreen);
    pfmt = SDL_AllocFormat(fmt);

    SdlTk_sdlsurf = SDL_CreateRGBSurface(SDL_SWSURFACE, width, height,
					 pfmt->BitsPerPixel,
					 pfmt->Rmask, pfmt->Gmask,
					 pfmt->Bmask, 0);
    if (SdlTk_sdlsurf == NULL) {
	fprintf(stderr, "Couldn't create SDL RGB surface: %s\n",
		SDL_GetError());
	fflush(stderr);
	return NULL;
    }

    SdlTk_sdlrend = SDL_CreateRenderer(SdlTk_sdlscreen, -1, 0);
    if (SdlTk_sdlrend == NULL) {
	fprintf(stderr, "Couldn't create SDL renderer: %s\n",
		SDL_GetError());
	fflush(stderr);
	return NULL;
    }
    SdlTk_sdltex = SDL_CreateTexture(SdlTk_sdlrend,
#ifdef ANDROID
				     SDL_PIXELFORMAT_RGB565,
#else
				     SDL_PIXELFORMAT_RGB888,
#endif
				     SDL_TEXTUREACCESS_STREAMING,
				     width, height);
    if (SdlTk_sdltex == NULL) {
	fprintf(stderr, "Couldn't create SDL texture: %s\n",
		SDL_GetError());
	fflush(stderr);
	return NULL;
    }

    /* Set title for window */
    SDL_SetWindowTitle(SdlTk_sdlscreen, display_name);

    /* From win/tkWinX.c TkpOpenDisplay */
    display = (Display *) ckalloc(sizeof (Display));
    memset(display, '\0', sizeof (Display));

    display->display_name = (char *) ckalloc(strlen(display_name)+1);
    strcpy(display->display_name, display_name);

    display->cursor_font = 1;
    display->nscreens    = 1;
    display->request     = 1;
    display->qlen        = 0;

    screen = (Screen *) ckalloc(sizeof (Screen));
    memset(screen, '\0', sizeof (Screen));
    screen->display = display;

    screen->white_pixel = SDL_MapRGB(pfmt, 255, 255, 255);
    screen->black_pixel = SDL_MapRGB(pfmt, 0, 0, 0);
    screen->cmap = None;

    display->screens = screen;
    display->nscreens = 1;
    display->default_screen = 0;
    display->vendor = "unknown vendor";
    display->proto_major_version = 11;
    display->proto_minor_version = 6;
    display->release = 0;

    /* TkWinDisplayChanged */
    screen->width = width;
    screen->height = height;
    screen->mwidth = (screen->width * 254 + 360) / 720; /* from Mac Tk */
    screen->mheight = (screen->height * 254 + 360) / 720;

    screen->root_depth = pfmt->BitsPerPixel;

    screen->root_visual = (Visual *) ckalloc(sizeof (Visual));
    memset(screen->root_visual, '\0', sizeof (Visual));
    screen->root_visual->visualid = 0;

    if (pfmt->palette != NULL) {
	screen->root_visual->map_entries = pfmt->palette->ncolors;
	screen->root_visual->class = PseudoColor;
	screen->root_visual->red_mask = 0x0;
	screen->root_visual->green_mask = 0x0;
	screen->root_visual->blue_mask = 0x0;
    } else if (screen->root_depth == 4) {
	screen->root_visual->class = StaticColor;
	screen->root_visual->map_entries = 16;
    } else if (screen->root_depth == 8) {
	screen->root_visual->class = StaticColor;
	screen->root_visual->map_entries = 256;
    } else if (screen->root_depth == 12) {
	screen->root_visual->class = TrueColor;
	screen->root_visual->map_entries = 32;
	screen->root_visual->red_mask = 0xf0;
	screen->root_visual->green_mask = 0xf000;
	screen->root_visual->blue_mask = 0xf00000;
    } else if (screen->root_depth == 15) {
	screen->root_visual->class = TrueColor;
	screen->root_visual->map_entries = 64;
	screen->root_visual->red_mask = pfmt->Rmask;
	screen->root_visual->green_mask = pfmt->Gmask;
	screen->root_visual->blue_mask = pfmt->Bmask;
    } else if (screen->root_depth == 16) {
	screen->root_visual->class = TrueColor;
	screen->root_visual->map_entries = 64;
	screen->root_visual->red_mask = pfmt->Rmask;
	screen->root_visual->green_mask = pfmt->Gmask;
	screen->root_visual->blue_mask = pfmt->Bmask;
    } else if (screen->root_depth >= 24) {
	screen->root_visual->class = TrueColor;
	screen->root_visual->map_entries = 256;
	screen->root_visual->red_mask = pfmt->Rmask;
	screen->root_visual->green_mask = pfmt->Gmask;
	screen->root_visual->blue_mask = pfmt->Bmask;
    }
    screen->root_visual->bits_per_rgb = pfmt->BitsPerPixel;

    screen->cmap = XCreateColormap(display, None, screen->root_visual,
	    AllocNone);

    /* Create the root (desktop) window */
    _w = (_Window *) ckalloc(sizeof (_Window));
    memset(_w, 0, sizeof (_Window));
    _w->type = DT_WINDOW;
    _w->sdl = SdlTk_sdlsurf;
    _w->format = SdlTkPixelFormat(SdlTk_sdlsurf);
    _w->atts.x = 0;
    _w->atts.y = 0;
    SDL_GetWindowSize(SdlTk_sdlscreen, &_w->atts.width, &_w->atts.height);
    _w->parentWidth = _w->atts.width;
    _w->parentHeight = _w->atts.height;
    _w->atts.border_width = 0;
    _w->atts.map_state = IsViewable;
    _w->visRgn = SdlTkRgnPoolGet();
    _w->visRgnInParent = SdlTkRgnPoolGet();

    screen->root = (Window) _w;
    values.graphics_exposures = False;
    values.foreground = 0x00000000;
    values.background = 0xFFFFFFFF;
    screen->default_gc =
	XCreateGC(display, screen->root,
		  GCGraphicsExposures|GCForeground|GCBackground,
		  &values);

    /* Nasty globals */
    SdlTkX_root = _w;
    SdlTkX_display = display;
    SdlTkX_screen = screen;

    /* See TkSDLDoOneEvent */
    SDL_VERSION(&wminfo.version);
#ifdef ANDROID
    display->fd = -1;
    SDL_EventState(SDL_APP_LOWMEMORY, SDL_ENABLE);
    SDL_EventState(SDL_APP_TERMINATING, SDL_ENABLE);
    SDL_EventState(SDL_APP_WILLENTERBACKGROUND, SDL_ENABLE);
    SDL_EventState(SDL_APP_DIDENTERBACKGROUND, SDL_ENABLE);
    SDL_EventState(SDL_APP_WILLENTERFOREGROUND, SDL_ENABLE);
    SDL_EventState(SDL_APP_DIDENTERFOREGROUND, SDL_ENABLE);
    SDL_EventState(SDL_FINGERDOWN, SDL_ENABLE);
    SDL_EventState(SDL_FINGERUP, SDL_ENABLE);
    SDL_EventState(SDL_FINGERMOTION, SDL_ENABLE);
    SDL_JoystickOpen(0);
    SDL_EventState(SDL_JOYAXISMOTION, SDL_ENABLE);
    SDL_JoystickUpdate();
    SDL_EventState(SDL_JOYAXISMOTION, SDL_DISABLE);
#else
    if (SDL_GetWindowWMInfo(SdlTk_sdlscreen, &wminfo) <= 0) {
	display->fd = -1;
    } else {
	fakeXDisplay = (struct FakeXDisplay *) wminfo.info.x11.display;
	display->fd = fakeXDisplay->fd;
    }
#endif

    return display;
}

void
XPutBackEvent(Display *display, XEvent *event)
{
}

int
XPutImage(Display *display, Drawable d, GC gc, XImage *image,
	  int src_x, int src_y, int dest_x, int dest_y,
	  unsigned int width, unsigned int height)
{
    SdlTkGfxPutImage(d, image, src_x, src_y, dest_x, dest_y, width, height);
    return 0;
}

/* TkTreeCtrl loupe uses this */
void
XQueryColors(Display *display, Colormap colormap, XColor *defs_in_out,
	     int ncolors)
{
    int i;
    Uint32 rm, gm, bm;
    int rs, gs, bs;

    rm = SdlTk_sdlsurf->format->Rmask;
    gm = SdlTk_sdlsurf->format->Gmask;
    bm = SdlTk_sdlsurf->format->Bmask;

    rs = SdlTk_sdlsurf->format->Rshift;
    gs = SdlTk_sdlsurf->format->Gshift;
    bs = SdlTk_sdlsurf->format->Bshift;

    for (i = 0; i < ncolors; i++) {
	defs_in_out[i].red = ((defs_in_out[i].pixel & rm) >> rs) / 255.0 * USHRT_MAX;
	defs_in_out[i].green = ((defs_in_out[i].pixel & gm) >> gs) / 255.0 * USHRT_MAX;
	defs_in_out[i].blue = ((defs_in_out[i].pixel & bm) >> bs) / 255.0 * USHRT_MAX;
    }
}

Bool
XQueryPointer(Display *display, Window w, Window *root_return,
	      Window *child_return, int *root_x_return,
	      int *root_y_return, int *win_x_return, int *win_y_return,
	      unsigned int *mask_return)
{
    int state;

    display->request++;

    *mask_return = 0;

    state = SDL_GetMouseState(root_x_return, root_y_return);
    *win_x_return = *root_x_return;
    *win_y_return = *root_y_return;

    if (state & SDL_BUTTON(1))
	*mask_return |= Button1Mask;
    if (state & SDL_BUTTON(2))
	*mask_return |= Button2Mask;
    if (state & SDL_BUTTON(3))
	*mask_return |= Button3Mask;
    return True;
}

int
XQueryTree(Display *display, Window w, Window *root_return,
	   Window *parent_return, Window **children_return,
	   unsigned int *nchildren_return)
{
    _Window *_w = (_Window *) w;
    _Window *child;
    int n = 0;

    display->request++;

    *root_return = SdlTkX_screen->root;
    *parent_return = (Window) _w->parent;

    if (_w->child == NULL) {
	*nchildren_return = 0;
	return 1;
    }

    /* Count children */
    child = _w->child;
    while (child != NULL) {
	n++;
	child = child->next;
    }

    /* Make array of children */
    *children_return = (Window *) ckalloc(sizeof (Window) * n);
    n = 0;
    child = _w->child;
    while (child != NULL) {
	(*children_return)[n++] = (Window) child;
	child = child->next;
    }
    *nchildren_return = n;

    return 1;
}

/*
The XReconfigureWMWindow() function issues a ConfigureWindow request on the
specified top-level window. If the stacking mode is changed and the request
fails with a BadMatch error, the error is trapped by Xlib and a synthetic
ConfigureRequestEvent containing the same configuration parameters is sent
to the root of the specified window. Window managers may elect to receive
this event and treat it as a request to reconfigure the indicated window.
It returns a nonzero status if the request or event is successfully sent;
otherwise, it returns a zero status.
*/
/* Called by TkWmRestackToplevel */
Status
XReconfigureWMWindow(Display *display, Window w, int screen_number,
		     unsigned int mask, XWindowChanges *changes)
{
    _Window *_w = (_Window *) w;
    _Window *parent = _w->parent;
    _Window *sibling = NULL;

    display->request++;

    if (mask & CWStackMode) {

	SdlTkScreenChanged();

	/* Attempting to restack a wrapper? Restack decframe instead. */
	/* override_redirects won't have a decframe however */
	if (parent != NULL && parent->dec != NULL) {
	    _w = parent;
	    parent = parent->parent;
	}

	/* Stack above/below decframe of sibling if any */
	if (mask & CWSibling) {
	    sibling = (_Window *) changes->sibling;
	    if (sibling->parent->dec != NULL) {
		sibling = sibling->parent;
	    }
	}

	SdlTkRestackWindow(_w, sibling, changes->stack_mode);
	SdlTkRestackTransients(_w);
    }

    return 0;
}

#if 0
int
XRectInRegion(Region r, int x, int y, unsigned int width, unsigned int height)
{
    return 0;
}
#endif

void
XRefreshKeyboardMapping(XMappingEvent *event_map)
{
}

int
XReparentWindow(Display *display, Window w, Window parent, int x, int y)
{
    _Window *_parent = (_Window *) parent;
    _Window *_w = (_Window *) w;
    _Window *wdec = NULL;
    XEvent event;

    display->request++;

    /* Remove from old parent */
    if (_w->parent != NULL) {
	if (_w->parent->dec != NULL) {
	    wdec = _w->parent;
	}
	SdlTkRemoveFromParent(_w);
    }

    /* Add to new parent */
    _w->parent = _parent;
    _w->next = _parent->child;
    _parent->child = _w;

    /* Update position */
    _w->atts.x = x;
    _w->atts.y = y;

    event.type = ReparentNotify;
    event.xreparent.serial = display->request;
    event.xreparent.send_event = False;
    event.xreparent.display = display;
    event.xreparent.event = w;
    event.xreparent.window = w;
    event.xreparent.parent = parent;
    event.xreparent.x = x;
    event.xreparent.y = y;
    event.xreparent.override_redirect = _w->atts.override_redirect;
    Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);

    if (_w->fullscreen && !_parent->fullscreen) {
	int xx, yy, ww, hh;

	_parent->atts_saved = _w->atts;
	xx = yy = 0;
	ww = SdlTk_sdlsurf->w;
	hh = SdlTk_sdlsurf->h;
	if (_parent->dec != NULL) {
	    xx -= DEC_FRAME_WIDTH;
	    yy -= DEC_TITLE_HEIGHT;
	    ww += DEC_FRAME_WIDTH * 2;
	    hh += DEC_TITLE_HEIGHT + DEC_FRAME_WIDTH;
	}
	XMoveResizeWindow(display, (Window) _parent, xx, yy, ww, hh);
	while (!IS_ROOT((Window) _parent)) {
	    _parent->fullscreen = 1;
	    _parent = _parent->parent;
	}
    }

    /* Destroy decorative frame */
    if (wdec && wdec->child == NULL) {
	XDestroyWindow(display, (Window) wdec);
    }

    return 0;
}

void
XResizeWindow(Display *display, Window w,
	      unsigned int width, unsigned int height)
{
    _Window *_w = (_Window *) w;

    display->request++;

    if (_w->fullscreen) {
	if (_w->atts.your_event_mask & StructureNotifyMask) {
	    SdlTkGenerateConfigureNotify(display, w);
	}
	return;
    }

    if ((int) width < 1)
	width = 1;
    if ((int) height < 1)
	height = 1;

    /* If this window has a decorative frame, resize it */
    if (_w->parent != NULL && _w->parent->dec != NULL) {
	_Window *wdec = _w->parent;

	wdec->atts.width = width + DEC_FRAME_WIDTH * 2;
	wdec->atts.height = height + DEC_TITLE_HEIGHT + DEC_FRAME_WIDTH;

	/* A window's requested width/height are *inside* its borders */
	/* A child window is clipped within its parent's borders */
	wdec->parentWidth = wdec->atts.width + 2 * wdec->atts.border_width;
	wdec->parentHeight = wdec->atts.height + 2 * wdec->atts.border_width;
    }

    _w->atts.width = width;
    _w->atts.height = height;

    /* A window's requested width/height are *inside* its borders */
    /* A child window is clipped within its parent's borders */
    _w->parentWidth = width + 2 * _w->atts.border_width;
    _w->parentHeight = height + 2 * _w->atts.border_width;

    if (_w->atts.your_event_mask & StructureNotifyMask)
	SdlTkGenerateConfigureNotify(display, w);

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkVisRgnChanged(_w->parent, VRC_CHANGED | VRC_DO_PARENT, 0, 0);
    else
	SdlTkVisRgnChanged(_w, VRC_CHANGED | VRC_DO_PARENT, 0, 0);

    SdlTkScreenChanged();
}

Window
XRootWindow(Display *display, int screen_number)
{
    display->request++;
    return SdlTkX_screen->root;
}

void
XSelectInput(Display *display, Window w, long event_mask)
{
    _Window *_w = (_Window *) w;

    display->request++;
    _w->atts.your_event_mask = event_mask;
}

int
XSendEvent(Display *display, Window w, Bool propagate, long event_mask,
	   XEvent *event_send)
{
    display->request++;
    if (event_send->xany.type == ClientMessage &&
	event_send->xclient.message_type == nwms_atom &&
	event_send->xclient.data.l[1] == nwmsf_atom) {
	_Window *_w = (_Window *) event_send->xany.window;
	int fullscreen = event_send->xclient.data.l[0];
	int send_nwms = 0;
	_Window *_ww = _w;

	if (fullscreen && !_w->fullscreen) {
	    int xx, yy, ww, hh;

	    _w->atts_saved = _w->atts;
	    xx = yy = 0;
	    ww = SdlTk_sdlsurf->w;
	    hh = SdlTk_sdlsurf->h;
	    if (_w->parent != NULL && _w->parent->dec != NULL) {
		xx -= DEC_FRAME_WIDTH;
		yy -= DEC_TITLE_HEIGHT;
		ww += DEC_FRAME_WIDTH * 2;
		hh += DEC_TITLE_HEIGHT + DEC_FRAME_WIDTH;
	    }
	    XMoveResizeWindow(display, (Window) _w, xx, yy, ww, hh);
	    while (!IS_ROOT((Window) _ww)) {
		_ww->fullscreen = 1;
		_ww = _ww->parent;
	    }
	    send_nwms = 1;
	} else if (!fullscreen && _w->fullscreen) {
	    while (!IS_ROOT((Window) _ww)) {
		_ww->fullscreen = 0;
		_ww = _ww->parent;
	    }
	    XMoveResizeWindow(display, (Window) _w,
			      _w->atts_saved.x, _w->atts_saved.y,
			      _w->atts_saved.width, _w->atts_saved.height);
	    send_nwms = 1;
	}
	if (send_nwms) {
	    XPropertyEvent xproperty;

	    memset(&xproperty, 0, sizeof (xproperty));
	    xproperty.type = PropertyNotify;
	    xproperty.atom = nwms_atom;
	    xproperty.display = display;
	    xproperty.window = (Window) _w;
	    xproperty.state = _w->fullscreen ?
		PropertyNewValue : PropertyDelete;
	    Tk_QueueWindowEvent((XEvent *) &xproperty, TCL_QUEUE_TAIL);
	}
	return 1;
    }
    Tk_QueueWindowEvent(event_send, TCL_QUEUE_TAIL);
    return 1;
}

int
XSetCommand(Display *display, Window w, char **argv, int argc)
{
    return 0;
}

void 
XSetBackground(Display *display, GC gc, unsigned long background)
{
    gc->background = background;
}

int
XSetClassHint(Display *display, Window w, XClassHint *class_hints)
{
    return 0;
}

void
XSetClipMask(Display *display, GC gc, Pixmap pixmap)
{
    if (pixmap == None) {
	if (gc->clip_mask) {
	    ckfree((char*) gc->clip_mask);
	    gc->clip_mask = None;
	}
	return;
    }

    if (gc->clip_mask == None) {
	gc->clip_mask = (Pixmap)ckalloc(sizeof (TkpClipMask));
    }
    ((TkpClipMask*)gc->clip_mask)->type = TKP_CLIP_PIXMAP;
    ((TkpClipMask*)gc->clip_mask)->value.pixmap = pixmap;
}

void
XSetStipple(Display *display, GC gc, Pixmap stipple)
{
    gc->stipple = stipple;
}

void
XSetFillStyle(Display *display, GC gc, int fill_style)
{
    gc->fill_style = fill_style;
}

void
XSetClipOrigin(Display *display, GC gc, int clip_x_origin, int clip_y_origin)
{
    gc->clip_x_origin = clip_x_origin;
    gc->clip_y_origin = clip_y_origin;
}

void
XSetDashes(Display *display, GC gc, int dash_offset, _Xconst char *dash_list,
	   int n)
{
    char *p = &(gc->dashes);

    gc->dash_offset = dash_offset;
    if (n > MAX_DASH_LIST_SIZE) n = MAX_DASH_LIST_SIZE;
    while (n-- > 0) {
	*p++ = *dash_list++;
    }
    *p = 0;
}

XErrorHandler
XSetErrorHandler(XErrorHandler handler)
{
    return NULL;
}

void
XSetFont(Display *display, GC gc, Font font)
{
    gc->font = font;
}

void 
XSetForeground(Display *display, GC gc, unsigned long foreground)
{
    gc->foreground = foreground;
}

void
XSetIconName(Display *display, Window w, _Xconst char *icon_name)
{
}

void
XSetInputFocus(Display *display, Window focus, int revert_to, Time time)
{
    _Window *_w;
    XEvent event;

    display->request++;

    if (SdlTkX_focus_window == focus)
	return;

    if (SdlTkX_focus_window != None) {
	event.type = FocusOut;
	event.xfocus.serial = ++display->request;
	event.xfocus.send_event = False;
	event.xfocus.display = display;
	event.xfocus.window = SdlTkX_focus_window;
	event.xfocus.mode = NotifyNormal;
	event.xfocus.detail = NotifyNonlinear;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }

    SdlTkX_focus_window = focus;
    _w = (_Window *) focus;
    if (_w == NULL)
	SdlTkX_focus_window_not_override = None;
    else if (!_w->atts.override_redirect)
	SdlTkX_focus_window_not_override = focus;

    if (focus != None && focus != PointerRoot) {
	event.type = FocusIn;
	event.xfocus.serial = ++display->request;
	event.xfocus.send_event = False;
	event.xfocus.display = display;
	event.xfocus.window = focus;
	event.xfocus.mode = NotifyNormal;
	event.xfocus.detail = NotifyNonlinear;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }
}

void
XSetLineAttributes(Display *display, GC gc, unsigned int line_width,
		   int line_style, int cap_style, int join_style)
{
    gc->line_width = line_width;
    gc->line_style = line_style;
    gc->cap_style = cap_style;
    gc->join_style = join_style;
}

int
XSetRegion(Display *display, GC gc, Region r)
{
    if (r == None) {
	if (gc->clip_mask) {
	    ckfree((char*) gc->clip_mask);
	    gc->clip_mask = None;
	}
	return 1;
    }

    if (gc->clip_mask == None) {
	gc->clip_mask = (Pixmap)ckalloc(sizeof (TkpClipMask));
    }
    ((TkpClipMask*)gc->clip_mask)->type = TKP_CLIP_REGION;
    ((TkpClipMask*)gc->clip_mask)->value.region = (TkRegion) r;
	return 1;
}

void
XSetSelectionOwner(Display *display, Atom selection, Window owner, Time time)
{
    static Window current_primary = None, current_clipboard = None;
    Window *current, clear = None;
    XEvent event;

    if (selection == None) {
	/* called through SDL_CLIPBOARDUPDATE */
	if (current_primary != None) {
	    clear = current_primary;
	    current_primary = None;
	    event.type = SelectionClear;
	    event.xselectionclear.serial = display->request;
	    event.xselectionclear.send_event = False;
	    event.xselectionclear.display = display;
	    event.xselectionclear.window = clear;
	    event.xselectionclear.selection = XA_PRIMARY;
	    event.xselectionclear.time = time;
	    Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
	}
	if (clipboard != None && current_clipboard != None) {
	    current = &current_clipboard;
	    selection = clipboard;
	    goto sendClr;
	}
	return;
    }
    if (selection == XA_PRIMARY) {
	current = &current_primary;
    } else if (selection == clipboard) {
	current = &current_clipboard;
    } else {
	return;
    }
    if (owner == None && *current != None) {
	SDL_SetClipboardText("");
    }
sendClr:
    clear = *current;
    *current = owner;
    if (clear != None) {
	event.type = SelectionClear;
	event.xselectionclear.serial = display->request;
	event.xselectionclear.send_event = False;
	event.xselectionclear.display = display;
	event.xselectionclear.window = clear;
	event.xselectionclear.selection = selection;
	event.xselectionclear.time = time;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }
}

int
XSetTransientForHint(Display *display, Window w, Window prop_window)
{
    _Window *_w, *_p, *_parent;

    _w = (_Window *) w;
    _p = (_Window *) prop_window;
    if (_p != NULL) {
	_parent = _p->parent;
	while (_parent != NULL && _parent->dec == NULL) {
	    _p = _parent;
	    _parent = _p->parent;
	}
    }
    _w->master = _p;
    if (IS_ROOT(_p)) {
	XMapWindow(display, w);
	SdlTkBringToFrontIfNeeded(_w);
	XSetInputFocus(SdlTkX_display, (Window) SdlTkWrapperForWindow(_w),
		    RevertToParent, CurrentTime);
	/* Frames need redrawing if the focus changed */
	SdlTkScreenChanged();
    }
    return 1;
}

void
XSetTSOrigin(Display *display, GC gc, int x, int y)
{
    gc->ts_x_origin = x;
    gc->ts_y_origin = y;
}

void
XSetWindowBackground(Display *display, Window w, unsigned long background_pixel)
{
}

void
XSetWindowBackgroundPixmap(Display *display, Window w, Pixmap background_pixmap)
{
}

void
XSetWindowBorder(Display *display, Window w, unsigned long border_pixel)
{
}

void
XSetWindowBorderPixmap(Display *display, Window w, Pixmap border_pixmap)
{
}

void
XSetWindowBorderWidth(Display *display, Window w, unsigned int width)
{
    _Window *_w = (_Window *) w;

    display->request++;

    _w->atts.border_width = width;
    _w->parentWidth = _w->atts.width + 2 * width;
    _w->parentHeight = _w->atts.height + 2 * width;
    SdlTkScreenChanged();
}

void
XSetWindowColormap(Display *display, Window w, Colormap colormap)
{
}

void
XSetWMClientMachine(Display *display, Window w, XTextProperty *text_prop)
{
}

Status
XSetWMColormapWindows(Display *display, Window w, Window *colormap_windows,
		      int count)
{
    return 0;
}

int
XSetWMHints(Display *display, Window w, XWMHints *wm_hints)
{
    return 0;
}

void
XSetWMNormalHints(Display *display, Window w, XSizeHints *hints)
{
    _Window *_w = (_Window *) w;

    if (hints->flags & PBaseSize) {
	_w->size.base_width = hints->base_width;
	_w->size.base_height = hints->base_height;
    }
    if (hints->flags & PMinSize) {
	_w->size.min_width = hints->min_width;
	_w->size.min_height = hints->min_height;
    }
    if (hints->flags & PMaxSize) {
	_w->size.max_width = hints->max_width;
	_w->size.max_height = hints->max_height;
    }
    if (hints->flags & PResizeInc) {
	_w->size.width_inc = hints->width_inc;
	_w->size.height_inc = hints->height_inc;
    }
    _w->size.flags = hints->flags;
}

int
XStoreName(Display *display, Window w, _Xconst char *window_name)
{
    return 0;
}

Status
XStringListToTextProperty(char **list, int count,
			  XTextProperty *text_prop_return)
{
    return (Status) 0;
}

KeySym
XStringToKeysym(_Xconst char *string)
{
    return NoSymbol;
}

#if 0
void
XSubtractRegion(Region sra, Region srb, Region dr_return)
{
}
#endif

int
XSync(Display *display, Bool discard)
{
    display->request++;
    return 0;
}

int
XSynchronize(Display *display, Bool discard)
{
    display->request++;
    return 0;
}

int
XTextWidth(XFontStruct *font_struct, const char *string, int count)
{
    return SdlTkGfxTextWidth(font_struct->fid, string, count);
}

int
XTextWidth16(XFontStruct *font_struct, const XChar2b *string, int count)
{
    return SdlTkGfxTextWidth(font_struct->fid, (char *) string, count);
}

/*
If XTranslateCoordinates() returns True, it takes the src_x and src_y
coordinates relative to the source window's origin and returns these
coordinates to dest_x_return and dest_y_return relative to the destination
window's origin. If XTranslateCoordinates() returns False, src_w and dest_w
are on different screens, and dest_x_return and dest_y_return are zero.
If the coordinates are contained in a mapped child of dest_w, that child is
returned to child_return. Otherwise, child_return is set to None.
*/
Bool
XTranslateCoordinates(Display *display, Window src_w, Window dest_w,
		      int src_x, int src_y, int *dest_x_return,
		      int *dest_y_return, Window *child_return)
{
    _Window *_src = (_Window *) src_w;
    _Window *_dest = (_Window *) dest_w;
    int rootx, rooty;

    SdlTkRootCoords(_src, &rootx, &rooty);
    src_x += rootx;
    src_y += rooty;

    SdlTkRootCoords(_dest, &rootx, &rooty);
    *dest_x_return = src_x - rootx;
    *dest_y_return = src_y - rooty;

    *child_return = (Window) SdlTkPointToWindow(_dest, src_x, src_y, True);
    if (*child_return == dest_w)
	*child_return = None;

    return True;
}

void
XUngrabKeyboard(Display *display, Time time)
{
}

#if 0
int
XUngrabPointer(Display *display, Time time)
{
    return 0;
}
#endif

int
XUngrabServer(Display *display)
{
    return 0;
}

#if 0
void
XUnionRectWithRegion(XRectangle *rectangle, Region src_region,
		     Region dest_region_return)
{
}
#endif

/*
"The XUnmapWindow() function unmaps the specified window and causes the X
server to generate an UnmapNotify event. If the specified window is already
unmapped, XUnmapWindow() has no effect. Normal exposure processing on formerly
obscured windows is performed. Any child window will no longer be visible until
another map call is made on the parent. In other words, the subwindows are
still mapped but are not visible until the parent is mapped. Unmapping a window
will generate Expose events on windows that were formerly obscured by it."
*/
/* Tk generates UnmapNotify events for all the children recursively, but I
 * can't figure out where that is done. */
void
XUnmapWindow(Display *display, Window w)
{
    _Window *_w = (_Window *) w;
    XEvent event;

    if (_w->atts.map_state == IsUnmapped)
	return;

    display->request++;

    /* Unmap decorative frame */
    if (_w->parent != NULL && _w->parent->dec != NULL) {
	_w->parent->atts.map_state = IsUnmapped;
    }

    _w->atts.map_state = IsUnmapped;

    /* Tk only cares about this for wrapper windows */
    if (_w->atts.your_event_mask & StructureNotifyMask) {
	event.type = UnmapNotify;
	event.xunmap.serial = display->request;
	event.xunmap.send_event = False;
	event.xunmap.display = display;
	event.xunmap.event = w;
	event.xunmap.window = w;
	event.xunmap.from_configure = False;
	Tk_QueueWindowEvent(&event, TCL_QUEUE_TAIL);
    }

    if (_w->parent != NULL && _w->parent->dec != NULL)
	SdlTkVisRgnChanged(_w->parent, VRC_CHANGED | VRC_DO_PARENT, 0, 0);
    else
	SdlTkVisRgnChanged(_w, VRC_CHANGED | VRC_DO_PARENT, 0, 0);

    /* "All FocusOut events caused by a window unmap are generated after any
     * UnmapNotify event" */
    if (SdlTkX_focus_window_not_override == w)
	SdlTkX_focus_window_not_override = None;
    if (SdlTkX_focus_window == w)
	SdlTkLostFocusWindow();

    SdlTkScreenChanged();
}

void
XWindowEvent(Display *display, Window w, long event_mask, XEvent *event_return)
{
}

int
XWithdrawWindow(Display *display, Window w, int screen_number)
{
    XUnmapWindow(display, w);
    return 1;
}

int
XmbLookupString(XIC ic, XKeyPressedEvent *event, char *buffer_return,
		int bytes_buffer, KeySym *keysym_return, Status *status_return)
{
    return 0;
}

VisualID
XVisualIDFromVisual(Visual *visual)
{
    return 0;
}

void
XWarpPointer(Display *display, Window src_w, Window dest_w,
	     int src_x, int src_y, unsigned int src_width,
	     unsigned int src_height, int dest_x, int dest_y)
{
}

