[manpage_begin relformat n 0.10.2]
[comment {
# This software is copyrighted 2004 - 2011 by G. Andrew Mangogna.
# The following terms apply to all files associated with the software unless
# explicitly disclaimed in individual files.
# 
# The authors hereby grant permission to use, copy, modify, distribute,
# and license this software and its documentation for any purpose, provided
# that existing copyright notices are retained in all copies and that this
# notice is included verbatim in any distributions. No written agreement,
# license, or royalty fee is required for any of the authorized uses.
# Modifications to this software may be copyrighted by their authors and
# need not follow the licensing terms described here, provided that the
# new terms are clearly indicated on the first page of each file where
# they apply.
# 
# IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES
# THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
# IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
# NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
# OR MODIFICATIONS.
# 
# GOVERNMENT USE: If you are acquiring this software on behalf of the
# U.S. government, the Government shall have only "Restricted Rights"
# in the software and related documentation as defined in the Federal
# Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
# are acquiring the software on behalf of the Department of Defense,
# the software shall be classified as "Commercial Computer Software"
# and the Government shall have only "Restricted Rights" as defined in
# Clause 252.227-7013 (c) (1) of DFARs.  Notwithstanding the foregoing,
# the authors grant the U.S. Government and others acting in its behalf
# permission to use and distribute the software in accordance with the
# terms specified in this license.
# 
#  *++
# MODULE:
#   relformat -- format a relation into tabular text
# ABSTRACT:
#   This file contains the documentation for the "relformat" command.
#   Relformat is part of the TCLRAL package.
# 
# $RCSfile: relformat.man,v $
# $Revision: 1.22 $
# $Date: 2012/02/26 19:09:04 $
#  *--
}]
[moddesc "Relation formatting"]
[titledesc "Text formatting for relations"]
[copyright "2004 - 2012 by G. Andrew Mangogna"]
[require ral [opt 0.10.2]]
[description]
This manpage describes a set of commands that are used for
generating text output of relation and tuple values.
These commands are part of the Tcl Relational Algebra Library (ral) package.

[section DEPENDENCIES]
The commands described here depend upon access to the [package struct::matrix],
[package report] and [package csv] packages of the Tcl standard library.
If your installation does not include [emph tcllib] then these commands
will not be available to you.

[section COMMANDS]
[list_begin definitions]
[call [cmd "::ral::relformat"] [arg relationValue] [opt title] [opt sortAttrs]\
    [opt noheading]]

The [cmd relformat] command returns a string that contains a human
readable form of the relation given by [arg relationValue].
[cmd Relformat] is intended to be to relations what the [cmd parray]
command is to arrays, [emph i.e.] a easy means of obtaining human
readable output.
Rather than writing the output directly to a channel,
[cmd relformat] returns it as a string.
The returned string does not have a trailing newline character and so
is suitable for handing directly to [cmd puts].
If the optional [arg title] argument is present, then it is used
as a caption at the bottom of the relation printout.
If the options [arg sortAttrs] argument is given then the relation is
sorted by the list of attributes in [arg sortAttrs] before being displayed.
If the [arg noheading] argument is set to 1, then two rows of attribute
name and attribute type that by default are placed as a heading of the output
are omitted.

[example {
% puts [relformat $::DOG Dog]
+-------+---------+
|DogName|Breed    |
|string |string   |
+-------+---------+
|Fido   |Poodle   |
|Sam    |Collie   |
|Spot   |Terrier  |
|Rover  |Retriever|
|Fred   |Spaniel  |
|Jumper |Mutt     |
+-------+---------+
Dog
---
% puts [relformat $::OWNERSHIP Ownership {DogName Acquired}]
+---------+-------+--------+
|OwnerName|DogName|Acquired|
|string   |string |string  |
+---------+-------+--------+
|Sue      |Fido   |2001    |
|George   |Fido   |2001    |
|Jim      |Fred   |2003    |
|Mike     |Rover  |2002    |
|Sue      |Sam    |2000    |
|George   |Sam    |2000    |
|Alice    |Spot   |2001    |
+---------+-------+--------+
Ownership
---------
% puts [relformat $::OWNER Owner "" 1]
+------+--+-------------+
|Sue   |24|Cupertino    |
|George|35|Sunnyvale    |
|Alice |30|San Jose     |
|Mike  |50|San Jose     |
|Jim   |42|San Francisco|
+------+--+-------------+
Owner
-----
% puts [relformat [relation group $::OWNERSHIP Owners OwnerName] "" DogName]
+-------+--------+-----------+
|DogName|Acquired|Owners     |
|string |string  |Relation   |
+-------+--------+-----------+
|Fido   |2001    |+---------+|
|       |        ||OwnerName||
|       |        ||string   ||
|       |        |+---------+|
|       |        ||Sue      ||
|       |        ||George   ||
|       |        |+---------+|
|Fred   |2003    |+---------+|
|       |        ||OwnerName||
|       |        ||string   ||
|       |        |+---------+|
|       |        ||Jim      ||
|       |        |+---------+|
|Rover  |2002    |+---------+|
|       |        ||OwnerName||
|       |        ||string   ||
|       |        |+---------+|
|       |        ||Mike     ||
|       |        |+---------+|
|Sam    |2000    |+---------+|
|       |        ||OwnerName||
|       |        ||string   ||
|       |        |+---------+|
|       |        ||Sue      ||
|       |        ||George   ||
|       |        |+---------+|
|Spot   |2001    |+---------+|
|       |        ||OwnerName||
|       |        ||string   ||
|       |        |+---------+|
|       |        ||Alice    ||
|       |        |+---------+|
+-------+--------+-----------+
}]


[call [cmd "::ral::tuple2matrix"] [arg tupleValue] [opt noheading]]

The [cmd tuple2matrix] command returns a matrix containing the values
in [arg tupleValue].
The matrix is created using the [package struct::matrix] package
from the standard Tcl library.
By default, the first two rows of the matrix contain the attribute
names and types.
Setting the [arg noheading] argument to 1,
removes those rows from the returned matrix.
It is the responsibility of the caller to [cmd destroy] the matrix
when it is no longer needed.

[call [cmd "::ral::relation2matrix"] [arg relationValue] [opt sortAttr]\
	[opt noheading]]

The [cmd relation2matrix] command returns a matrix containing the values
in [arg relationValue].
The matrix is created using the [package struct::matrix] package
from the standard Tcl library.
If present, the [arg sortAttr] argument is a list of attributes
that are used to sort the values before placing in the matrix.
By default, the first two rows of the matrix contain the attribute
names and types.
Setting the [arg noheading] argument to 1,
removes those rows from the returned matrix.
It is the responsibility of the caller to [cmd destroy] the matrix
when it is no longer needed.

[call [cmd "::ral::csv"] [arg relationValue] [opt sortAttrs] [opt noheading]]

The [cmd csv] command formats the relation value given by [arg relationValue]
into comma separated value formatted string.
If [arg sortAttrs] is given, then the tuples of the relation value
will appear in the order implied by the list of attributes contained
in [arg sortAttrs].
If [arg noheading] is given as 1, then no heading will be placed in the returned
CSV string.
By default, heading information is placed in the output.
This command uses the [package csv] package from [cmd tcllib].

[call [cmd "::ral::csvToFile"] [arg relationValue] [arg fileName]\
	[opt sortAttr] [opt noheading]]
The [cmd csvToFile] command writes the value of [arg relationValue] to
the file named [arg fileName] in comma separated values format.
If [arg sortAttrs] is given, then the tuples of the relation value
will appear in the order implied by the list of attributes contained
in [arg sortAttrs].
If [arg noheading] is given as 1, then no heading will be placed in the returned
CSV string.
By default, heading information is placed in the output.
This command uses the [package csv] package from [cmd tcllib].

[call [cmd "::ral::tupleAsTable"] [opt capRows]]
The [cmd tupleAsTable] command is a report style for use with the
[package report] package in [cmd tcllib].
This is the default report style used by the commands in TclRAL for
formatting tuples.

[call [cmd "::ral::relationAsTable"] [opt idCols] [opt capRows]]
The [cmd relationAsTable] command is a report style for use with the
[package report] package in [cmd tcllib].
This is the default report style used by the commands in TclRAL for
formatting relations.

[list_end]

[see_also relvar relation tuple]

[keywords tuple relation relvar]

[manpage_end]
