[manpage_begin serialize n 0.10.2]
[comment {
# This software is copyrighted 2004 - 2011 by G. Andrew Mangogna.
# The following terms apply to all files associated with the software unless
# explicitly disclaimed in individual files.
# 
# The authors hereby grant permission to use, copy, modify, distribute,
# and license this software and its documentation for any purpose, provided
# that existing copyright notices are retained in all copies and that this
# notice is included verbatim in any distributions. No written agreement,
# license, or royalty fee is required for any of the authorized uses.
# Modifications to this software may be copyrighted by their authors and
# need not follow the licensing terms described here, provided that the
# new terms are clearly indicated on the first page of each file where
# they apply.
# 
# IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES
# THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
# IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
# NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
# OR MODIFICATIONS.
# 
# GOVERNMENT USE: If you are acquiring this software on behalf of the
# U.S. government, the Government shall have only "Restricted Rights"
# in the software and related documentation as defined in the Federal
# Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
# are acquiring the software on behalf of the Department of Defense,
# the software shall be classified as "Commercial Computer Software"
# and the Government shall have only "Restricted Rights" as defined in
# Clause 252.227-7013 (c) (1) of DFARs.  Notwithstanding the foregoing,
# the authors grant the U.S. Government and others acting in its behalf
# permission to use and distribute the software in accordance with the
# terms specified in this license.
# 
#  *++
# MODULE:
#
# ABSTRACT:
# 
# $RCSfile: serialize.man,v $
# $Revision: 1.19 $
# $Date: 2012/02/26 19:09:04 $
#  *--
}]
[moddesc "Relation persistence"]
[titledesc "Persistent storage for relations"]
[copyright "2004 - 2012 by G. Andrew Mangogna"]
[require ral [arg [opt 0.10.2]]]
[description]
This manpage describes a set of commands that are used for
saving the values of relvars on external storage.
All of the output commands below take an optional [arg pattern] argument.
If present, then the command is applied to relvars that match the given
[arg pattern].
Otherwise by default all relvars are considered.
All of the input commands below take an optional [arg namespace] argument.
If present, then the command will restore the relvars relative to the given
[arg namespace].
Otherwise, relvars are restored relative to the global namespace.
Upon serialization and output, the entire relvar name path is maintained.
This allows relvars to be restored to their same relative positions
in a different namespace from which they were originally taken.
Since TclRAL manages relvar names using [cmd namespace]-like syntax,
this may be used to manage distinct sets of relvars without risking
naming conflicts.

[section COMMANDS]
[list_begin definitions]
[call [cmd "::ral::serialize"] [arg [opt pattern]]]

The [cmd serialize] command returns a string that represents the values
and constraints for all of the relvars contained within [arg namespace].
The string returned by [cmd serialize] may be given to [cmd deserialize]
to restore the values of the relvars.

[call [cmd "::ral::serializeToFile"] [arg fileName] [arg [opt pattern]]]

The [cmd serializeToFile] command invokes [cmd serialize] and places the
resulting serialization string into the file given by [arg fileName].

[call [cmd "::ral::deserialize"] [arg serialization] [arg [opt namespace]]]

The [cmd deserialize] command restores the values and constraints on a
set of relvars.
The [arg serialization] argument must be a value returned from the
[cmd serialize] command.
If the [arg namespace] argument is given,
then the relvars and constraints are placed in the given namespace which
need not exist prior to invoking the command.
The [cmd deserialize] command also uses a set of heuristics to attempt
to deserialize relvar data originally composed by the 0.8.X revisions
of [package ral].
If it determines that the data may be from an older version, then
[cmd deserialize-0.8.X] is invoked to restore the values.
The [cmd deserialize-0.8.X] command may be invoked directly, see below.

[call [cmd "::ral::deserializeFromFile"] [arg fileName] [arg [opt namespace]]]

The [cmd deserializeFromFile] command reads the file given by the
[arg fileName] argument and invokes [cmd deserialize] on its contents.

[call [cmd "::ral::merge"] [arg serialization] [arg [opt namespace]]]
The [cmd merge] command merges the relvars and constraints contained
in [arg serialization].
If [arg namespace] is given then the merge is into that namespace and
otherwise the merge is into the global namespace.
The merge attempts to do a union of the relvars and constraints onto
those already existing.
The merge is done strictly be name with no consideration of structure,
meaning that any relvars or constraints in
[arg serialization] that do not currently exist are created,
but existing relvars and constraints whose names match those in
[arg serialization] have their structure preserved.
The relation values of the relvars contained in [arg serialization] are
unioned against the existing relvar by the same name.
The return value of the command is a list of relvar names for which the
union operation fails.
The union of relvar values is carried out in a transaction.

[call [cmd "::ral::mergeFromFile"] [arg fileName] [arg [opt namespace]]]
The [cmd mergeFromFile] command invokes [cmd ::ral::merge] on the
contents of the file given by the [arg fileName] argument.

[call [cmd "::ral::deserialize-0.8.X"] [arg serialization]\
        [arg [opt namespace]]]
The [cmd deserialize-0.8.X] command provides a way to read relvar values
and constraints that were stored using the 0.8.X revisions of [package ral].

[call [cmd "::ral::deserializeFromFile-0.8.X"] [arg fileName]\
        [arg [opt namespace]]]
The [cmd deserializeFromFile-0.8.X] command invokes
[cmd deserialize-0.8.X] on the contents of the [arg fileName] file.

[call [cmd "::ral::storeToMk"] [arg fileName] [arg [opt pattern]]]

The [cmd storeToMk] command stores the state of a set of relvars into
a metaKit database.
Each relvar is stored in a separate metaKit [emph view].
Several additional views are created to hold system catalog information.
The additional views have names that start with [emph __ral].
If [arg fileName] exists already, it is renamed to be [arg fileName]~ before
a new file is created with the current state of the relvars.

[call [cmd "::ral::loadFromMk"] [arg fileName] [arg [opt namespace]]]
The [cmd loadFromMk] command restores the state of a set of relvars
from the information contained in a metaKit database.
That database must have been created using the [cmd storeToMk] command.

[call [cmd "::ral::mergeFromMk"] [arg fileName] [arg [opt namespace]]]
The [cmd mergeFromMk] command merges the contents of the metakit contained
in [arg fileName] into the namespace given by [arg namespace].
The rules of merging are the same as described for the [cmd merge]
command above.

[call [cmd "::ral::storeToSQLite"] [arg fileName] [arg [opt pattern]]]
The [cmd storeToSQLite] command stores the state of a set of relvars into
a SQLite database.
Each relvar is stored in a separate SQL table.
The schema created for the relvars includes referential (a.k.a. foreign key)
constraints and creates indices for both identifiers and foreign key
references.
No all TclRAL constraints can be enforced by an SQL database,
but many as can be mapped to SQL foreign key references.
Several additional tables are created to hold system catalog information.
The additional tables have names that start with [emph __ral]
and they hold information that allows the relvar state to be restored
exactly.
If [arg fileName] exists already, it is renamed to be [arg fileName]~ before
a new file is created with the current state of the relvars.

[call [cmd "::ral::loadFromSQLite"] [arg fileName] [arg [opt namespace]]]
The [cmd loadFromSQLite] command restores the state of a set of relvars
from the information contained in a SQLite database.
That database must have been created using the [cmd storeToSQLite] command.

[call [cmd "::ral::dump"] [arg [opt pattern]]]

The [cmd dump] command returns a Tcl script that when evaluated will
restore the state of a set of relvars to be the same as when the [cmd dump]
command was executed.
The [cmd dump] command is another form of serialization for a set of relvars
and is often useful when creating Tcl packages that create an empty
schema of relvars.

[call [cmd "::ral::dumpToFile"] [arg fileName] [arg [opt pattern]]]
The [cmd dumpToFile] invokes the [cmd dump] command and writes the
resulting script to the file given by [arg fileName].

[list_end]

[section "SERIALIZATION FORMAT"]
The format used generated by [cmd serialize] and expected by
[cmd deserialize] is a Tcl list consisting of eight elements.
List elements form a dictionary whose keys denote the parts of the serialization
and whose values contain the relvar information as described below.

[list_begin itemized]
[item]
Version <library version>
[item]
Relvars <list of relvar defs>
    [list_begin itemized]
    [item]
    <relvar name>
    [item]
    <relation heading>
    [item]
    <list of relvar identifiers>
    [list_end]
[item]
Constraints <list of constraints>
    [list_begin itemized]
    [item]
    association | partition | correlation
    [item]
    <constraint definition>
        [list_begin itemized]
        [item]
        <association constraint definition>
        [para]
        <association name> <relvar name> <attribute list> <mult/cond>
            <relvar name> <attribute list> <mult/cond>
        [item]
        <partition constraint definition>
        [para]
        <partition name> <superset> <attribute list>
            <subset1> <attribute list> <subset2> <attribute list> ...
        [item]
        <correlation constraint definition>
        [para]
        <?-complete?> <correlation name> <relvar name>
            <attribute list> <mult/cond> <relvar name> <attribute list>
            <attribute list> <mult/cond> <relvar name> <attribute list>
        [list_end]
    [list_end]
[item]
Values <list of relvar names/relation values>
    [list_begin itemized]
    [item]
    <relvar name>
    [item]
    <relation value>
    [list_end]
[list_end]

[see_also relvar relation tuple]

[keywords tuple relation relvar]

[manpage_end]
