[manpage_begin tuple n 0.10.2]
[comment {
# This software is copyrighted 2004 - 2011 by G. Andrew Mangogna.
# The following terms apply to all files associated with the software unless
# explicitly disclaimed in individual files.
# 
# The authors hereby grant permission to use, copy, modify, distribute,
# and license this software and its documentation for any purpose, provided
# that existing copyright notices are retained in all copies and that this
# notice is included verbatim in any distributions. No written agreement,
# license, or royalty fee is required for any of the authorized uses.
# Modifications to this software may be copyrighted by their authors and
# need not follow the licensing terms described here, provided that the
# new terms are clearly indicated on the first page of each file where
# they apply.
# 
# IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES
# THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# 
# THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
# IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
# NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
# OR MODIFICATIONS.
# 
# GOVERNMENT USE: If you are acquiring this software on behalf of the
# U.S. government, the Government shall have only "Restricted Rights"
# in the software and related documentation as defined in the Federal
# Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
# are acquiring the software on behalf of the Department of Defense,
# the software shall be classified as "Commercial Computer Software"
# and the Government shall have only "Restricted Rights" as defined in
# Clause 252.227-7013 (c) (1) of DFARs.  Notwithstanding the foregoing,
# the authors grant the U.S. Government and others acting in its behalf
# permission to use and distribute the software in accordance with the
# terms specified in this license.
# 
#  *++
# MODULE:
#	tuple.man -- Manual page for the TclRal "tuple" command.
# ABSTRACT:
# 
# $RCSfile: tuple.man,v $
# $Revision: 1.22 $
# $Date: 2012/02/26 19:09:04 $
#  *--
}]
[moddesc "Tuple Operators"]
[titledesc "Operators for the Tuple data type"]
[copyright "2004 - 2012 by G. Andrew Mangogna"]
[require ral [opt 0.10.2]]
[description]
This manpage describes the
[cmd tuple]
command.
The
[cmd tuple]
command is part of the Tcl Relational Algebra Library (ral) package.
The ral package introduces an new Tcl data type called
[emph Tuple]
and this command provides the operators for the Tuple data type.

[section OVERVIEW]
Formally, a tuple is a set of components.
Each component consists of an attribute name, an attribute data type
and an attribute value.
The attribute name may be any Tcl string, although attribute names that
contain embedded blanks are particularly inconvenient.
The attribute data type must be one of the types listed below:

[list_begin itemized]
[item]
string
[item]
int
[item]
long
[item]
wideInt
[item]
bignum
[item]
double
[item]
boolean
[item]
list
[item]
dict
[item]
bytearray
[item]
Tuple
[item]
Relation
[list_end]

If the attribute data type is [emph Tuple] or [emph Relation],
then the data type specifier must be a list of two elements,
the first being the type name Tuple or Relation and the second being
another list contain the tuple or relation heading.
Tuples and relations thus may contain tuple-value or relation-valued attributes.

[para]
These types have the same name as the corresponding Tcl type
and the Tcl type is used for the values.
The [emph bignum] and [emph dict] types are only available in Tcl 8.5.
Any value associated with an attribute must be coercible to the stated
type.
Since [emph string] is the univeral Tcl type,
then any attribute of type [emph string] effectively has no type check.
Some Tuple operations result in expressions being evaluated on the
attribute value.
All operations are carried out in the stated data type.
So for example, determining the relative order of two attributes whose type
is [emph double] will be carried out in double arithmetic even if the
string representation of the value could be construed to be a different type.

[para]

Tuples are similar in many ways to other Tcl data types such as [cmd dict],
[cmd ::struct::record] or keyed lists from TclX.
However, the tuple type was built to operate specfically in conjunction
with the Relation type and does have some specific rules that the other
types do not have.

Tuples are sets of components and as such have the following rules.

[list_begin itemized]
[item]
All attribute names must be unique.

[item]
Any attribute value assigned to a particular attribute is coerced into the
attribute data type for that attribute and it is an error if the value
string assigned to an attribute does not represent a valid value of the
attribute data type.

[item]
There is no inherent left to right ordering in tuples.
Clearly, the implementation may store components in a particular order
and any string representation must have some left to right ordering to it
(since I write in a Latin alphabet which is left to right ordered),
but the operations on Tuples do not expose or depend upon any ordering of
components.
Consequently, using string and list operators on the string representation
of a Tuple are not guaranteed to yield the correct result.
The implementation is free to choose any internal order and any ordering
of the string representation it wishes as long as the Tuple operators function
as described.
[list_end]

[section {STRING REPRESENTATION}]
Like any Tcl value, tuples have a string representation.
The string representation of a tuple is a specially formatted list
consisting of two elements:
[list_begin enum]
[enum]
The tuple heading.
[enum]
The tuple values.
[list_end]
The tuple heading is an even numbered list consisting alternately of
an attribute name and an attribute data type.
Data types must be one of those listed above.
[para]
The tuple values are also specified by a list consisting of an even
number of elements.
The even indexed elements are attribute names and the odd index elements
give the corresponding attribute value.
Note that the ordering of two lists is arbitrary in that attribute name /
value pairs need not be in the same order as the attribute name / type
pairs.
[para]
The following is a literal string representation of a tuple with
three attributes.
[example {
{Name string Breed string Age int} {Name Fido Breed Terrier Age 2}
}]
The following is a string representation that is equivalent to the
same tuple.
[example {
{Name string Breed string Age int} {Breed Terrier Name Fido Age 2}
}]

[section COMMANDS]
[list_begin definitions]
[call [cmd "::ral::tuple assign"] [arg tupleValue]\
    [opt "attrName | attr-var-pair ..."]]

The [cmd assign] subcommand provides a convenient way to place the values
of the attributes of a tuple into Tcl variables.
The [cmd assign] subcommand can place all the attributes into variables
or only a subset of the attributes.
The variables may be named the same as the attribute name or values
may be placed in variables of a specified name.
If no optional arguments are given,
then [cmd assign] places the value of each attribute
of a tuple into a Tcl variable that has the same name as the
attribute.
If any optional arguments are present, then only the given attributes are
assigned to variables.
Each optional argument is considered as a list containing one or two elements.
If the argument is of the form [arg attrName], [emph i.e.] a single
element list, then it is taken as an attribute name and the corresponding
value is placed in a Tcl variable by the same name.
If the argument is of the form [arg attr-var-pair] then it is
taken as a two element list consisting of an attribute / variable name pair
and the corresponding attribute
value is assigned to a variable with the given name.
Assignments are made in left to right order and it is not an error to
assign the same attribute multiple times or to assign the same attribute
to multple variables.
Any existing variables that have the same name are assigned a new value.
Variables are created as necessary.
All variables are created in the local scope.
The [cmd assign] subcommand returns the number of variables assigned to which
necessarily is equal to either the degree of the tuple or the number
of optional arguments given.

[example {
% tuple assign {{Name string Age int} {Name John Age 25}}
2
% set Name
John
% set Age
25
}]

[call [cmd "::ral::tuple attributes"] [arg tupleValue]]
The [cmd attributes] subcommand returns a list of the attribute names
of [arg tupleValue].

[example {
% tuple attributes {{Name string Age int} {Name John Age 25}}
Name Age
}]


[call [cmd "::ral::tuple create"] [arg heading] [arg name-value-list]]

The [cmd create] subcommand creates a new tuple that has a heading
given by the [arg heading] argument and values given by the
[arg name-value-list] argument and returns the value of the new tuple.
The [arg heading] is specified by a list containing an even number of elements.
The [arg heading] list consists of alternating attribute names and
attribute data types.
The [arg name-value-list] must have an even number of elements and the
elements are treated as pairs.
The first element of a pair is taken to be an attribute name and the second is
taken as the corresponding value for the attribute.
This is the same form of list accepted by the [cmd "array set"] command.

When a tuple is created each value is converted to the underlying data
type specified in the heading of the tuple.
It is an error if the conversion fails.
It is also an error not to supply a value for every attribute or to attempt
to supply the value of any attribute more than once.


[example {
% tuple create {Number int Street string Zip string}\
	{Number 100 Zip 90214 Street Elm}
{Number int Street string Zip string} {Number 100 Street Elm Zip 90214}
% tuple create {Number int Street string Zip string}\
	{Number hundred Zip 90214 Street Elm}
bad value type for value, "hundred"
% tuple create {Number int Street string Zip string} {Number 100 Zip 90214}
wrong number of attributes specified, "Number 100 Zip 90214"
% tuple create {Number int Street string Zip string}\
	{Number 100 Zip 90214 Number 100}
duplicate attribute name, "Number"
% tuple create {Number int Street string Zip string}\
	{Number 100 Zip 90214 Street Elm Email john@net.net}
wrong number of attributes specified, "Number 100 Zip 90214 Street Elm Email john@net.net"
}]

[call [cmd "::ral::tuple degree"] [arg tupleValue]]

The [cmd degree] subcommand returns the degree of the tuple which is
the number of attributes the tuple has.

[example {
% tuple degree {{Name string Age int} {Name John Age 25}}
2
% tuple degree {{} {}}
0
}]

[call [cmd "::ral::tuple eliminate"] [arg tupleValue] [opt [arg "attr ..."]]]

The [cmd eliminate] subcommand returns a new tuple with the same
heading and values as [arg tupleValue] except that those attributes given
in the argument list are not present.
It is an error to attempt to eliminate attributes that are not part of
[arg tupleValue].

[example {
% set t1 [tuple create {Name string Age int} {Name John Age 25}]
{Name string Age int} {Name John Age 25}
% tuple eliminate $t1
{Name string Age int} {Name John Age 25}
% tuple eliminate $t1 Name
{Age int} {Age 25}
% tuple eliminate $t1 Street
unknown attribute name, "Street"
}]

[call [cmd "::ral::tuple equal"] [arg tuple1] [arg tuple2]]

The [cmd equal] subcommands returns "1" if [arg tuple1] is equal to
[arg tuple2] and "0" otherwise.
Two tuples are equal if they the same attribute names,
the corresponding attributes have the same type and
the corresponding attribute values are equal.
Because there is no inherent order to the attributes of a tuple,
there are many ways to specify the same tuple.
For example, the following tuples are equal.

[example {
% set t1 [tuple create {Name string Status int} {Name Fred Status 20}]
{Name string Status int} {Name Fred Status 20}
% set t2 [tuple create {Status int Name string} {Name Fred Status 20}]
{Status int Name string} {Status 20 Name Fred}
% tuple equal $t1 $t2
1
}]

This implies that only [cmd "tuple equal"] can reliably determine
tuple equality.
Using [cmd "string equal"] (or any other string based comparison operations)
to determine tuple equality is not reliable and should not be used

[call [cmd "::ral::tuple extend"] [arg tupleValue] [opt [arg "name type value ..."]]]

The [cmd extend] subcommand returns a new tuple with the same heading and
values as the [arg tupleValue] argument except that the new attributes given by
the [arg "name type value"] arguments are included.
The extension arguments of [arg name-type-value] must come in groups of three.
The three arguments
are a new attribute name, attribute data type and attribute
value in that order.
It is an error to attempt to [cmd extend] a tuple with an attribute name
that is already contained in [arg tupleValue].
Each new attribute value is converted to the appropriate type and it is
an error if that conversion fails.

[example {
% set t1 [tuple create {Name string} {Name Fred}]
{Name string} {Name Fred}
% tuple extend $t1 Age int 30 Sex string Male
{Name string Age int Sex string} {Name Fred Age 30 Sex Male}
% tuple extend $t1 Name string Jane
duplicate attribute name, "Name"
% tuple extend $t1 Age int Thirty
bad value type for value, "Thirty"
}]

[call [cmd "::ral::tuple extract"] [arg tupleValue] [arg attr] [opt [arg "attr2 ..."]]]

The [cmd extract] subcommand returns the value of one or more attributes.
If only a single [arg attr] is requested, then the attribute value
is the return value of the command.
If multiple [arg attr] are requested, then a list of attribute values
is returned.
The order of the returned list is the same as the order of the [arg attr]
arguments.

[example {
% set t1 [tuple create {Name string Age int} {Name {Fred Jones} Age 27}]
{Name string Age int} {Name {Fred Jones} Age 27}
% tuple extract $t1 Name
Fred Jones
% tuple extract $t1 Age Name
27 {Fred Jones}
% tuple extract $t1 Status
unknown attribute name, "Status"
}]

[call [cmd "::ral::tuple get"] [arg tupleValue]]

The [cmd get] subcommand returns a list consisting of pairs of elements.
The first element of each pair is an attribute name and the second
is the attribute value.
The form of the list is the same as that returned by the [cmd "array get"]
command and accepted by the [cmd "array set"] command.
The [cmd get] subcommand provides a convenient means to move tuple
values into an array.
The form of the list returned may also be used directly the [cmd dict] command.

[example {
% set t1 {{Name string Age int} {Name {Fred Jones} Age 27}}
{Name string Age int} {Name {Fred Jones} Age 27}
% set tinfo [tuple get $t1]
Name {Fred Jones} Age 27
% array set ainfo $tinfo

% parray ainfo
ainfo(Age)  = 27
ainfo(Name) = Fred Jones

% dict keys $tinfo
Age Name
}]


[call [cmd "::ral::tuple heading"] [arg tupleValue]]

The [cmd heading] subcommand returns the heading of the given [arg tupleValue].
The heading of a tuple is a list consisting of two elements.
The first element is the keyword [emph Tuple] and the second is list with
an even number of elements consisting of alternating
attribute names and attribute data types.

[example {
% set t {{Name string Age int} {Name {Fred Jones} Age 27}}
{Name string Age int} {Name {Fred Jones} Age 27}
% tuple heading $t
{Name string Age int}
}]

[call [cmd "::ral::tuple project"] [arg tupleValue] [opt [arg "attr ..."]]]

The [cmd project] subcommand returns a new tuple that consists of only the
attributes given by the [arg attr] arguments
with the corresponding values taken from [arg tupleValue].
It is not an error to project zero attributes (the nullary tuple projection),
the result being the tuple with no attributes.

[example {
% set t {{Name string Age int} {Name {Fred Jones} Age 27}}
{Name string Age int} {Name {Fred Jones} Age 27}
% tuple project $t Age
{Age int} {Age 27}
% tuple project $t
{} {}
}]

[call [cmd "::ral::tuple relation"] [arg tupleValue]]
The [cmd relation] subcommand returns a new relation value that contains
[arg tupleValue] as its only tuple.
The heading of the returned relation value is the same as that of
[arg tupleValue].
This subcommand corresponds to the [cmd "::ral::relation tuple"] command.

[call [cmd "::ral::tuple rename"] [arg tupleValue] [opt [arg "oldname newname ..."]]]

The [cmd rename] subcommand returns a new tuple where [arg oldname] is
replaced by [arg newname].
The [arg tupleValue] argument is not modified.
Many pairs of [arg oldname]/[arg newname] arguments may be given.
It is an error to attempt to give an [arg oldname] that is not an attribute
name in the tuple or to attempt to change the name of an attribute to be
one that already exists in the tuple.

[example {
% set t {{Name string Age int} {Name {Fred Jones} Age 27}}
{Name string Age int} {Name {Fred Jones} Age 27}
% tuple rename $t Name Person Age Status
{Person string Status int} {Person {Fred Jones} Status 27}
% tuple rename $t Name Person Person Name
{Name string Age int} {Name {Fred Jones} Age 27}
% tuple rename $t Name Person Name Nomen
unknown attribute name, "Name"
% tuple rename $t Name Age
duplicate attribute name, "Age"
% tuple rename $t
{Name string Age int} {Name {Fred Jones} Age 27}
}]


[call [cmd "::ral::tuple unwrap"] [arg tupleValue] [arg attr]]

The [cmd unwrap] subcommand creates a new tuple that expands the attributes of
a tuple valued attribute.
The [arg tupleValue] argument must be of Tuple type and
the [arg attr] argument must also be of Tuple type.
The returned tuple value will consists of all the attributes of the
original tuple minus the [arg attr] attribute plus all the attributes
of the [arg attr] attribute itself.
The [cmd unwrap] subcommand is useful for [emph un-nesting] tuples that
have tuple valued attributes.
For example, the tuple:


[example {
% set t {{Name string Address {Tuple {Number int Street string}}} {Name Fred Address {Number 100 Street Elm}}}
{Name string Address {Tuple {Number int Street string}}} {Name Fred Address {Number 100 Street Elm}}
% tuple unwrap $t Address
{Name string Number int Street string} {Name Fred Number 100 Street Elm}
% tuple unwrap $t Name
attribute must be of a Tuple type, "Name"
% set u {{Name string Address {Tuple {Number int Name string}}} {Name Fred Address {Number 100 Name Elm}}}
{Name string Address {Tuple {Number int Name string}}} {Name Fred Address {Number 100 Name Elm}}
% tuple unwrap $u Address
duplicate attribute name, "while unwrapping tuple"
}]


[call [cmd "::ral::tuple update"] [arg tupleValue]\
    [arg [opt "attr1 value1 attr2 value2 ..."]]]

The [cmd update] subcommand returns a new tuple that has the same
heading as [arg tupleValue] and that is modified by
replacing the attribute values given by the [arg attrN] arguments
with their corresponding values as given by the [arg valueN] arguments.
modifies the attribute values of a tuple in place.
It is an error to attempt to update an attribute that does exist,
[emph i.e.] the structure of the tuple may not be changed by this command.

[example {
% set t {{Name string Age int} {Name {Fred Jones} Age 27}}
{Name string Age int} {Name {Fred Jones} Age 27}
% tuple update $t Name {Jane Jones}
{Name string Age int} {Name {Jane Jones} Age 27}
% tuple update $t Status 20
unknown attribute name, "Status"
}]


[call [cmd "::ral::tuple wrap"] [arg tupleValue] [arg newAttr]\
        [arg [opt "attr1 attr2 ..."]]]

The [cmd wrap] subcommand creates a new tuple where some of the attributes
are contained in a Tuple valued attribute.
This command provides a means to create nested tuples, [emph i.e.]
tuples that contain tuple valued attributes.
The [arg tupleValue] argument must be a tuple and [arg newAttr] is the name the
the new tuple valued attribute will be given.
The [arg attrN] arguments are the names of attributes that will be placed
in the new tuple valued attribute.
Referring to the example from the [cmd "tuple unwrap"] command above:

[example {
% set t {{Name string Number int Street string} {Name Fred Number 100 Street Elm}}
{Name string Number int Street string} {Name Fred Number 100 Street Elm}
% tuple wrap $t Address Number Street
{Name string Address {Tuple {Number int Street string}}} {Name Fred Address {Number 100 Street Elm}}
}]

[list_end]

[see_also relvar relation]

[keywords tuple relation relvar]

[manpage_end]
