'\"
'\" Generated from dom.xml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH dom n "" Tcl ""
.BS
.SH NAME
dom \- Create an in-memory DOM tree from XML
.SH SYNOPSIS
.nf
package require tdom

\&\fBdom\fP \fImethod\fR ?\fIarg arg ...\fR?
.fi
.BE
.SH "DESCRIPTION "
.PP
This command provides the creation of complete DOM trees in memory. In
the usual case a string containing a XML information is parsed and converted
into a DOM tree. \fImethod\fR indicates a specific subcommand.
.PP
The valid methods are:
.TP
\&\fB\fBdom\fP \fBparse\fP ?\fIoptions\fB? ?\fIdata\fB?
\&\fRParses the XML information and builds up the DOM tree in memory
providing a Tcl object command to this DOM document object. Example:

      
.RS
.CS

dom parse $xml doc
$doc documentElement root
.CE
.PP
parses the XML in the variable xml, creates the DOM tree in memory,
make a reference to the document object, visible in Tcl as a document object
command, and assigns this new object name to the variable doc. When doc gets
freed, the DOM tree and the associated Tcl command object (document and all
node objects) are freed automatically.

      
      
.CS

set document [dom parse $xml]
set root     [$document documentElement]
.CE
.PP
parses the XML in the variable xml, creates the DOM tree in memory,
make a reference to the document object, visible in Tcl as a document object
command, and returns this new object name, which is then stored in
\&\fIdocument\fR.  To free the underlying DOM tree and the associative Tcl
object commands (document + nodes + fragment nodes) the document object command
has to be explicitly deleted by:


      
.CS

$document delete

.CE
or
.CS

rename $document ""
.CE
.PP
The valid options are:
.IP "\fB-simple\fR"
If \fI-simple\fR is
specified, a simple but fast parser is used (conforms not fully to XML
recommendation). That should double parsing and DOM generation speed. The
encoding of the data is not transformed inside the parser. The simple parser
does not respect any encoding information in the XML declaration. It skips over
the internal DTD subset and ignores any information in it. Therefor it doesn't
include defaulted attribute values into the tree, even if the according
attribute declaration is in the internal subset. It also doesn't expand
internal or external entity references other than the predefined entities and
character references.
.IP "\fB-html\fR"
If \fI-html\fR is specified, a fast HTML parser is
used, which tries to even parse badly formed HTML into a DOM tree.
.IP "\fB-keepEmpties\fR"
If \fI-keepEmpties\fR is
specified, text nodes, which contain only whitespaces, will be part of the
resulting DOM tree. In default case (\fI-keepEmpties\fR not given) those empty
text nodes are removed at parsing time.
.IP "\fB-channel  \fI<channel-ID>\fP\fR"
If \fI-channel <channel-ID>\fR is specified, the
input to be parsed is read from the specified channel. The encoding setting of
the channel (via fconfigure -encoding) is respected, ie the data read from the
channel are converted to UTF-8 according to the encoding settings, befor the
data is parsed.
.IP "\fB-baseurl  \fI<baseURI>\fP\fR"
If \fI-baseurl <baseURI>\fR is specified, the
baseURI is used as the base URI of the document. External entities referenced
in the document are resolved relative to this base URI. This base URI is also
stored within the DOM tree.
.IP "\fB-feedbackAfter  \fI<#bytes>\fP\fR"
If \fI-feedbackAfter <#bytes>\fR is specified, the
tcl command ::dom::domParseFeedback is evaluated after parsing every #bytes. If
you use this option, you have to create a tcl proc named
::dom::domParseFeedback, otherwise you will get an error. Please notice, that
the calls of ::dom::domParseFeedback are not done exactly every #bytes, but
always at the first element start after every #bytes.
.IP "\fB-externalentitycommand  \fI<script>\fP\fR"
If \fI-externalentitycommand <script>\fR is
specified, the specified tcl script is called to resolve any external entities
of the document. The actual evaluated command consists of this option followed
by three arguments: the base uri, the system identifier of the entity and the
public identifier of the entity. The base uri and the public identifier may be
the empty list. The script has to return a tcl list consisting of three
elements. The first element of this list signals, how the external entity is
returned to the processor. At the moment, the two allowed types are "string"
and "channel". The second element of the list has to be the (absolute) base URI
of the external entity to be parsed.  The third element of the list are data,
either the already read data out of the external entity as string in the case
of type "string", or the name of a tcl channel, in the case of type
"channel". Note that if the script returns a tcl channel, it will not be closed
by the processor.  It must be closed separately if it is no longer
required.
.IP "\fB-useForeignDTD  \fI<boolean>\fP\fR"
If <boolean> is true and the document does not have
an external subset, the parser will call the -externalentitycommand script with
empty values for the systemId and publicID arguments. Pleace notice, that, if
the document also doesn't have an internal subset, the
-startdoctypedeclcommand and -enddoctypedeclcommand scripts, if set, are not
called. The \fI-useForeignDTD\fR respects
.IP "\fB-paramentityparsing  \fI<always|never|notstandalone>\fP\fR"
The \fI-paramentityparsing\fR option controls, if the
parser tries to resolve the external entities (including the external DTD
subset) of the document, while building the DOM
tree. \fI-paramentityparsing\fR requires an argument, which must be either
"always", "never", or "notstandalone". The value "always" means, that the
parser tries to resolves (recursively) all external entities of the XML
source. This is the default, in case \fI-paramentityparsing\fR is omitted. The
value "never" means, that only the given XML source is parsed and no external
entity (including the external subset) will be resolved and parsed. The value
"notstandalone" means, that all external entities will be resolved and parsed,
with the execption of documents, which explicitly states standalone="yes" in
their XML declaration.
.PP
.RE
.TP
\&\fB\fBdom\fP \fBcreateDocument\fP \fIdocElemName\fB ?\fIobjVar\fB?
\&\fRCreates a new DOM document object with one element node with
node name \fIdocElemName\fR. The \fIobjVar\fR controls the
memory handling as explained above.
.TP
\&\fB\fBdom\fP \fBcreateDocumentNS\fP \fIuri\fB \fIdocElemName\fB ?\fIobjVar\fB?
\&\fRCreates a new DOM document object with one element node with
node name \fIdocElemName\fR. \fIUri\fR gives the namespace of the
document element to create. The \fIobjVar\fR controls the
memory handling as explained above.
.TP
\&\fB\fBdom\fP \fBcreateDocumentNode\fP ?\fIobjVar\fB?
\&\fRCreates a new, 'empty' DOM document object without any element
node. \fIobjVar\fR controls the memory handling as explained above.
.TP
\&\fB\fBdom\fP \fBsetResultEncoding\fP ?\fIencodingName\fB?
\&\fRIf \fIencodingName\fR is not given the current global
result encoding is returned.  Otherwise the global result encoding is set to
\&\fIencodingName\fR.  All character data, attribute values, etc. will
then be converted from UTF-8, which is delivered from the Expat XML parser, to
the given 8 bit encoding at XML/DOM parse time.  Valid values for
\&\fIencodingName\fR are: utf-8, ascii, cp1250, cp1251, cp1252, cp1253,
cp1254, cp1255, cp1256, cp437, cp850, en, iso8859-1, iso8859-2, iso8859-3,
iso8859-4, iso8859-5, iso8859-6, iso8859-7, iso8859-8, iso8859-9, koi8-r.
.TP
\&\fB\fBdom\fP \fBcreateNodeCmd\fP \fI?-returnNodeCmd?\fB \fI(element|comment|text|cdata|pi)Node\fB \fIcommandName\fB
\&\fRThis method creates Tcl commands, which in turn create tDOM nodes.
Tcl commands created by this command are only avaliable inside a script given to the
domNode method \fIappendFromScript\fR. If a command created with
\&\fIcreateNodeCmd\fR is invoked in any other context, it will return error. The
created command \fIcommandName\fR replaces any existing command or procedure
with that name. If the \fIcommandName\fR includes any namespace qualifiers,
it is created in the specified namespace.
.RS
.PP
If such command is invoked inside a script given as argument to
the domNode method \fIappendFromScript\fR, it creates a new node and
appends this node at the end of the child list of the invoking element
node. If the option \fI-returnNodeCmd\fR was given, the command returns the
created node as Tcl command. If this option was omitted, the command returns
nothing. Each command creates always the same type of node. Which type of
node is created by the command is determined by the first argument to the
\&\fIcreateNodeCmd\fR. The syntax of the created command depends on the
type of the node it creates.
.PP
If the first argument of the method is \fIelementNode\fR, the created
command will create an element node. The tag name of the created
node is \fIcommandName\fR without namespace qualifiers. The syntax of the
created command is:



.CS

\&\fBelementNodeCmd\fP \fI?attributeName attributeValue ...? ?script?\fR
\&\fBelementNodeCmd\fP \fI?-attributeName attributeValue ...? ?script?\fR
\&\fBelementNodeCmd\fP \fIname_value_list script\fR

.CE
.PP
The command syntax allows three different ways to specify the attributes of
the resulting element. These could be specified with \fIattributeName
attributeValue\fR argument pairs, in an "option style" way with
\&\fI-attriubteName attributeValue\fR argument pairs (the '-' character is only
syntactical sugar and will be stripped off) or as a Tcl list with elements
interpreted as attribute name and the corresponding attribute value.
The attribute name elements in the list may have a leading '-' character, which
will be stripped off.
.PP
Every \fIelementNodeCmd\fR accepts an optional Tcl script as last
argument. This script is evaluated as recursive \fIappendFromScript\fR script
with the node created by the \fIelementNodeCmd\fR as parent of all nodes
created by the script.
.PP
If the first argument of the method is \fItextNode\fR, the command will create
a text node. The syntax of the created command is:



.CS

\&\fBtextNodeCmd\fP ?-disableOutputEscaping? \fIdata\fR

.CE
.PP
If the optional flag \fI-disableOutputEscaping\fR is given, the
escaping of the ampersand character (&) and the left angle bracket (<)
inside the data is disabled. You should use this flag carefully.
.PP
If the first argument of the method is \fIcommentNode\fR, or
\&\fIcdataNode\fR, the command will create an comment node or CDATA section
node. The syntax of the created command is:



.CS

\&\fBnodeCmd\fP \fIdata\fR

.CE
.PP
If the first argument of the method is \fIpiNode\fR, the command will
create a processing instruction node. The syntax of the created
command is:



.CS

\&\fBpiNodeCmd\fP \fItarget data\fR

.CE
.RE
.TP
\&\fB\fBdom\fP \fBsetStoreLineColumn\fP \fI?boolean\fB?
\&\fRIf switched on, the DOM nodes will contain line and column
position information for the original XML document after parsing. The default
is, not to store line and column position information.
.TP
\&\fB\fBdom\fP \fBsetNameCheck\fP \fI?boolean\fB?
\&\fRIf NameCheck is true, every method which expects an XML Name,
a full qualified name or a processing instructing target will check, if the
given string is valid according to his production rule. For commands created
with the \fIcreateNodeCmd\fR method to be used in the context of
\&\fIappendFromScript\fR the status of the flag at creation time
decides. If NameCheck is true at creation time, the command will
check his arguments, otherwise not. The \fIsetNameCheck\fR
set this flag. It returns the current NameCheck flag state. The
default state for NameCheck is true.
.TP
\&\fB\fBdom\fP \fBsetTextCheck\fP \fI?boolean\fB?
\&\fRIf TextCheck is true, every command which expects XML Chars,
a comment, a CDATA section value or a processing instructing value will check,
if the given string is valid according to his production rule. For commands
created with the \fIcreateNodeCmd\fR method to be used in the
context of \fIappendFromScript\fR the status of the flag at
creation time decides. If TextCheck is true at creation time, the
command will check his arguments, otherwise not.The
\&\fIsetTextCheck\fR method set this flag. It returns the current
TextCheck flag state. The default state for TextCheck is true.
.TP
\&\fB\fBdom\fP \fBsetObjectCommands\fP ?\fI(automatic|token|command)\fB?
\&\fRControls, if documents and nodes are created as tcl commands or
as token to be
used with the domNode and domDoc commands. If the mode is
\&'automatic', then methods used at tcl commands will create tcl
commands and methods used at doc or node tokes will create tokens. If
the mode is 'command' then always tcl commands will be created. If
the mode is 'token', then always token will be created. The method
returns the current mode. This method is an experimental interface.
.TP
\&\fB\fBdom\fP \fBisName\fP \fIname\fB
\&\fRReturns 1, if \fIname\fR is a valid XML Name according to
production 5 of the XML
1.0 recommendation. This means, that \fIname\fR is a valid
XML element or attribute name. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisPIName\fP \fIname\fB
\&\fRReturns 1, if \fIname\fR is a valid XML processing instruction
target according to
production 17 of the XML 1.0 recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisNCName\fP \fIname\fB
\&\fRReturns 1, if \fIname\fR is a valid NCName according
to production 4 of the of the Namespaces in XML recommendation. Otherwise it returns
0.
.TP
\&\fB\fBdom\fP \fBisQName\fP \fIname\fB
\&\fRReturns 1, if \fIname\fR is a valid QName according
to production 6 of the of the Namespaces in XML recommendation. Otherwise it returns
0.
.TP
\&\fB\fBdom\fP \fBisCharData\fP \fIstring\fB
\&\fRReturns 1, if every character in \fIstring\fR is
a valid XML Char according to production 2 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisComment\fP \fIstring\fB
\&\fRReturns 1, if \fIstring\fR is
a valid comment according to production 15 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisCDATA\fP \fIstring\fB
\&\fRReturns 1, if \fIstring\fR is
valid according to production 20 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBisPIValue\fP \fIstring\fB
\&\fRReturns 1, if \fIstring\fR is
valid according to production 16 of the XML 1.0
recommendation. Otherwise it returns 0.
.TP
\&\fB\fBdom\fP \fBfeatureinfo\fP \fIfeature\fB
\&\fRThis method provides information about the used
build options and the expat version. The valid values for
the \fIfeature\fR argument are:
.RS
.IP "\fBexpatversion\fR"
Returns the version of the underlyling expat
version as string, something like
"exapt_2.1.0". This is. what the expat API
function XML_ExpatVersion() returns.
.IP "\fBexpatmajorversion\fR"
Returns the major version of the underlyling
expat version as integer.
.IP "\fBexpatminorversion\fR"
Returns the minor version of the underlyling
expat version as integer.
.IP "\fBexpatmicroversion\fR"
Returns the micro version of the underlyling
expat version as integer.
.IP "\fBdtd\fR"
Returns as boolean, if build with
\&\fI--enable-dtd\fR.
.IP "\fBns\fR"
Returns as boolean, if build with
\&\fI--enable-ns\fR.
.IP "\fBunknown\fR"
Returns as boolean, if build with
\&\fI--enable-unknown\fR.
.IP "\fBtdomalloc\fR"
Returns as boolean, if build with
\&\fI--enable-tdomalloc\fR.
.IP "\fBlessns\fR"
Returns as boolean, if build with
\&\fI--enable-lessns\fR.
.RE
.SH KEYWORDS
XML, DOM, document, node, parsing
