'\"
'\" Generated from domDoc.xml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH domDoc n "" Tcl ""
.BS
.SH NAME
domDoc \- Manipulates an instance of a DOM document object
.SH SYNOPSIS
.nf
\&\fBdomDocObjCmd\fP \fImethod\fR ?\fIarg arg ...\fR?
.fi
.BE
.SH "DESCRIPTION "
.PP
This command manipulates one particular instance of a document
object. \fImethod\fR indicates a specific method of the document class. These
methods should closely conform to the W3C recommendation "Document Object Model
(Core) Level 1" (http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html). Look
at these documents for a deeper understanding of the functionality.
.PP
The valid methods are:
.TP
\&\fB\fBdocumentElement\fP ?\fIobjVar\fB?
\&\fRReturns the top most element in the document (the root
element).
.TP
\&\fB\fBgetElementsByTagName\fP \fIname\fB
\&\fRReturns a list of all elements in the document matching
(glob style) \fIname\fR.
.TP
\&\fB\fBgetElementsByTagNameNS\fP \fIuri\fB \fIlocalname\fB
\&\fR Returns a list of all elements in the subtree
matching (glob style) \fIlocalname\fR and having the given namespace
\&\fIuri\fR.
.TP
\&\fB\fBcreateElement\fP \fItagName\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new element node with node name
\&\fItagName\fR, append it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given the new
node object is stored in this variable.
.TP
\&\fB\fBcreateElementNS\fP \fIurl\fB \fItagName\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new element node within a namespace
having \fIuri\fR as the URI and node name \fItagName\fR, which
could include the namespace prefix, append it to the hidden fragment list in
the document object and returns the node object.  If \fIobjVar\fR is
given the new node object is stored in this variable.
.TP
\&\fB\fBcreateTextNode\fP \fItext\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new text node with node value
\&\fItext\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
node object is stored in this variable.
.TP
\&\fB\fBcreateComment\fP \fItext\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new comment node with value
\&\fItext\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
comment node object is stored in this variable.
.TP
\&\fB\fBcreateCDATASection\fP \fIdata\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new CDATA node with node value
\&\fIdata\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
node object is stored in this variable.
.TP
\&\fB\fBcreateProcessingInstruction\fP \fItarget\fB \fIdata\fB ?\fIobjVar\fB?
\&\fRCreates a process instruction, appends it to the hidden
fragment list in the document object and returns the node object.  If
\&\fIobjVar\fR is given, the new node object is stored in this variable.
.TP
\&\fB\fBdelete\fP
\&\fRExplicitly deletes the document, including the associated
Tcl object commands (for nodes, fragment/new nodes, the document object itself)
and the underlying DOM tree.
.TP
\&\fB\fBgetDefaultOutputMethod\fP
\&\fRReturns the default output method of the document. This is
usually a result of a XSLT transformation.
.TP
\&\fB\fBasXML\fP \fB?-indent none/1..8?\fP \fB?-channel channelId?\fP \fB?-escapeNonASCII?\fP \fB?-doctypeDeclaration <boolean>?\fP \fB?-escapeAllQuot?\fP
\&\fRReturns the DOM tree as an (optional indented) XML
string or sends the output directly to the given channelId. If the
option \fI-escapeNonASCII\fR is given, every non 7 bit ASCII
character in attribute values or element PCDATA content will be
escaped as character reference in decimal representation. The flag
\&\fI-doctypeDeclaration\fR determines, whether there will be a DOCTYPE
declaration emitted before the first node of the document. The default
is, to do not. The DOCTYPE name will always be the element name of the
document element. An external entity declaration of the external
subset is only emitted, if the document has a system identifier. If
the option \fI-escapeAllQuot\fR is given, quotation marks will be
escaped with &quot; even in text content of elements.
.TP
\&\fB\fBasHTML\fP \fB?-channel channelId?\fP \fB?-escapeNonASCII?\fP \fB?-htmlEntities?\fP \fB?-doctypeDeclaration <boolean>?\fP
\&\fRReturns the DOM tree serialized acording to HTML rules (HTML
elements are recognized regardless of case, without end tags for emtpy HTML
elements etc.), as string or sends the output directly to the given
channelId. If the option \fI-escapeNonASCII\fR is given, every non 7 bit ASCII
character in attribute values or element PCDATA content will be escaped as
character reference in decimal representation. If the option
\&\fI-htmlEntities\fR is given, a character is outputed using a HTML 4.01
character entity reference, if one is defined for it. The flag
\&\fI-doctypeDeclaration\fR determines, whether there will be a DOCTYPE
declaration emitted before the first node of the document. The default is, to
do not. The DOCTYPE name will always be the element name of the document
element without case normalization. An external entity declaration of the
external subset is only emitted, if the document has a system identifier. The
doctype declaration will be written from the avaliable informations, without
check, if this is a known (w3c) HTML version information or if the document
confirms to the given HTML version.
.TP
\&\fB\fBasText\fP
\&\fRThe asText method outputs the result tree by outputting
the string-value of every text node in the result tree in document
order without any escaping. In effect, this is what the xslt output method
"text" (XSLT 1.0 recommendation, section 16.3) does.
.TP
\&\fB\fBpublicId\fP \fI?publicId?\fB
\&\fRReturns the public identifier of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the public identifier of the document is set to this
value.
.TP
\&\fB\fBsystemId\fP \fI?systemId?\fB
\&\fRReturns the system identifier of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the system identifier of the document is set to this
value.
.TP
\&\fB\fBinternalSubset\fP \fI?internalSubset?\fB
\&\fRReturns the internal subset of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the internal subset of the document is set to this
value. Note, that none of the parsing methods preserve the internal subset
of a document; a freshly parsed document will always have an empty internal
subset. Also note, that the method doesen't do any syntactical check on a
given internal subset.
.TP
\&\fB\fBcdataSectionElements\fP \fI(?URI:?localname|*) ?<boolean>?\fB
\&\fRThis method allows to control, for which element nodes
the text node childs will be serialized as CDATA sections (this affects only
serialization with the asXML method, no text node is altered in any
way by this method). IF the method is called with an element name as
first argument and a boolean with value true as second argument, every
text node child of every element node in the document with the same
name as the first argument will be serialized as CDATA section. If the
second argument is a boolean with value false, all text nodes of all
elements with the same name as the first argument will be serialized
as usual. Namespaced element names have to given in the form
namespace_URI:localname, not in the otherwise usual prefix:localname
form. With two arguments called, the method returns the used boolean
value. If the method is called with only an element name, it will
return a boolean value, indicating, if the text nodes childs of all
elements with that name in the document will be serialized as CDATA
section elements (return value 1) or not (return value 0). If the
method is called with only one argument and that argument is an
asterisk ('*'), then the method returns an unordered list of all
element names of the document, for which the text node childs will be
serialized as CDATA section nodes.
.TP
\&\fB\fBselectNodesNamespaces\fP \fB?prefixUriList?\fP
\&\fRThis method allows to control a document global prefix
to namespace URI mapping, which will be used for selectNodes method
calls (on document as well as on all nodes, which belongs to the
document), if it is not overwritten by using the -namespaces option of
the selectNodes method. Any namespace prefix within an xpath
expression will be first resolved against this list. If the list bind
the same prefix to different namespaces, then the first binding will
win. If a prefix could not resolved against the document global prefix
/ namespaces list, then the namespace definitions in scope of the
context node will be used to resolve the prefix, as usual. If the
optional argument \fIprefixUriList\fR is given, then the global prefix /
namespace list is set to this list and returns it. Without
the optional argument the method returns the current list. The
default is the empty list.
.TP
\&\fB\fBxslt\fP \fB?-parameters parameterList?\fP \fB?-ignoreUndeclaredParameters?\fP \fB?-xsltmessagecmd script?\fP \fIstylesheet\fB \fI?outputVar?\fB
\&\fRApplies an XSLT transformation on the whole document of the node
object using the XSLT \fIstylesheet\fR (given as domDoc). Returns a document
object containing the result document of the transformation and stores that
document object in the optional \fIoutputVar\fR, if that was given.
.RS
.PP
The optional \fI-parameters\fR option sets top level
<xsl:param> to string values. The \fIparameterList\fR has to be a tcl
list consisting of parameter name and value pairs.
.PP
If the option \fI-ignoreUndeclaredParameters\fR is given, then parameter
names in the \fIparameterList\fR given to the \fI-parameters\fR options that
are not declared as top-level parameters in the stylesheet are silently
ignored. Without this option, an error is raised, if the user tries to set a
top-level parameter, which is not declared in the stylesheet.
.PP
The \fI-xsltmessagecmd\fR option sets a callback for xslt:message elements
in the stylesheet. The actual command consists of the script, given as argument
to the option, appended with the XML Fragment from instantiating the
xsl:message element content as string (as if the XPath string() function would
have been applied to the XML Fragment) and a flag, which indicates, if the
xsl:message has an attribute "terminate" with the value "yes".
.RE
.TP
\&\fB\fBtoXSLTcmd\fP ?\fIobjVar\fB?
\&\fRIf the DOM tree represents a valid XSLT stylesheet, this method
transforms the DOM tree into an xslt command, otherwise it returns error. The
created xsltCmd is returnd and stored in the \fIobjVar\fR, if a var name was
given. A successful transformation of the DOM tree to an xsltCmd removes the
domDoc cmd and all nodeCmds of the document.
.RS
.PP
The syntax of the created xsltCmd is:

 

.CS

\&\fBxsltCmd\fP \fBmethod\fP \fB?arg ...?\fP

.CE
.PP
The valid methods are:
.TP
\&\fB\fBtransform\fP \fB?-parameters parameterList?\fP \fB?-ignoreUndeclaredParameters?\fP \fB?-xsltmessagecmd script?\fP \fIdomDoc\fB \fI?outputVar?\fB
\&\fRApplies XSLT transformation on the document
\&\fIdomDoc\fR. Returns a document object containing the
result document of that transformation and stores it in the optional
\&\fIoutputVar\fR.
.RS
.PP
The optional \fI-parameters\fR option sets top level
<xsl:param> to string values. The \fIparameterList\fR has to be a tcl
list consisting of parameter name and value pairs.
.PP
If the option \fI-ignoreUndeclaredParameters\fR is given, then parameter
names in the \fIparameterList\fR given to the \fI-parameters\fR options that
are not declared as top-level parameters in the stylesheet are silently
ignored. Without this option, an error is raised, if the user tries to set a
top-level parameter, which is not declared in the stylesheet.
.PP
The \fI-xsltmessagecmd\fR option sets a callback for xslt:message elements
in the stylesheet. The actual command consists of the script, given as argument
to the option, appended with the XML Fragment from instantiating the
xsl:message element content as string (as if the XPath string() function would
have been applied to the XML Fragment) and a flag, which indicates, if the
xsl:message has an attribute "terminate" with the value "yes".
.RE
.TP
\&\fB\fBdelete\fP
\&\fRDeletes the xsltCmd and cleans up all used recourses
.PP
If the first argument to an xsltCmd is a domDoc or starts with a "-",
then the command is processed in the same way as
\&\fI<xsltCmd> transform\fR.
.RE
.TP
\&\fB\fBnormalize\fP \fI?-forXPath?\fB
\&\fRPuts all Text nodes in the document
into a "normal" form where only structure (e.g., elements,
comments, processing instructions and CDATA
sections) separates Text nodes, i.e., there
are neither adjacent Text nodes nor empty Text nodes. If the option
\&\fI-forXPath\fR is given, all CDATA sections in the nodes are
converted to text nodes, as a first step before the
normalization.
.TP
\&\fB\fBnodeType\fP
\&\fRReturns the node type of the document node. This is always
DOCUMENT_NODE.
.TP
\&\fB\fBgetElementById\fP \fIid\fB
\&\fRReturns the node having a id attribute with value
\&\fIid\fR or the emtpy string, if no node has an id attribute with that value.
.TP
\&\fB\fBfirstChild\fP \fB?objVar?\fP
\&\fRReturns the first top level node of the document.
.TP
\&\fB\fBlastChild\fP \fB?objVar?\fP
\&\fRReturns the last top level node of the document.
.TP
\&\fB\fBappendChild\fP \fInewChild\fB
\&\fRAppend \fInewChild\fR to the end of the list of top level nodes
of the document.
.TP
\&\fB\fBremoveChild\fP \fIchild\fB
\&\fRRemoves \fIchild\fR from the list of top level nodes of the
document. \fIchild\fR will be part of the document fragment list
after this operation. It is not physically deleted.
.TP
\&\fB\fBhasChildNodes\fP
\&\fRReturns 1 if the document has any nodes in the tree. Otherwise 0 is returned.
.TP
\&\fB\fBchildNodes\fP
\&\fRReturns a list of the top level nodes of the document.
.TP
\&\fB\fBownerDocument\fP \fB?domObjVar?\fP
\&\fRReturns the document itself.
.TP
\&\fB\fBinsertBefore\fP \fInewChild\fB  \fIrefChild\fB
\&\fRInsert \fInewChild\fR before the \fIrefChild\fR into the list of
top level nodes of the document. If \fIrefChild\fR is the empty string, insert
\&\fInewChild\fR at the end of the top level nodes.
.TP
\&\fB\fBreplaceChild\fP \fInewChild\fB  \fIoldChild\fB
\&\fRReplace \fIoldChild\fR with \fInewChild\fR in the list of
children of that node. The \fIoldChild\fR node will be part of the
document fragment list after this operation.
.TP
\&\fB\fBappendFromList\fP \fIlist\fB
\&\fRParses \fIlist\fR , creates an according DOM subtree and
appends this subtree at the end of the current list of top level nodes of the document.
.TP
\&\fB\fBappendXML\fP \fIXMLstring\fB
\&\fRParses \fIXMLstring\fR, creates an according DOM subtree and
appends this subtree at the end of the current list of top level nodes of the document.
.TP
\&\fB\fBselectNodes\fP \fB?-namespaces prefixUriList?\fP \fB?-cache <boolean>?\fP \fIxpathQuery\fB \fB?typeVar?\fP
\&\fR
.RS
.PP
Returns the result of applying the XPath query
\&\fIxpathQuery\fR to the document. The context node of the query is the root
node in the sense of the XPath recommendation (not the document element). The
result can be a string/value, a list of strings, a list of nodes or a list
of attribute name / value pairs. If \fItypeVar\fR is given
the result type name is stored into that variable (empty,
bool, number, string, nodes, attrnodes or mixed).
.PP
The argument \fIxpathQuery\fR has to be a valid XPath
expression. However, there is one exception to that rule. Tcl variable
names can appear in the XPath statement at any position where it is
legal according to the rules of the XPath syntax to put an XPath
variable. The value of the variable is substituted for the variable
name. Ignoring the syntax rules of XPath the Tcl variable name may be
any legal Tcl var name: local variables, global variables, array
entries and so on.
.PP
The option \fI-namespaces\fR expects a tcl list with prefix /
namespace pairs as argument. If this option is not given, then any
namespace prefix within the xpath expression will be first resolved
against the list of prefix / namespace pairs set with the
selectNodesNamespaces method for the document, the node belongs to. If
this fails, then the namespace definitions in scope of the context
node will be used to resolve the prefix. If this option is given, any
namespace prefix within the xpath expression will be first resolved
against that given list (and ignoring the document global prefix /
namespace list). If the list bind the same prefix to different
namespaces, then the first binding will win.  If this fails, then the
namespace definitions in scope of the context node will be used to
resolve the prefix, as usual.
.PP
If the \fI-cache\fR option is used with a true value, then the
\&\fIxpathQuery\fR will be looked up in a document specific cache. If the query
is found, then the stored pre-compiled query will be used. If the
query isn't found, it will be pre-compiled and stored in the cache,
for use in further calls. Please notice, that the \fIxpathQuery\fR as given as
string is used as key for the cache. This means, that equal XPath
expressions, which differ only in white space are treated as
different cache entries. Special care is needed, if the XPath
expression includes namespace prefixes. During pre-compilation, the
prefixes will be resolved first to the prefix / namespace pairs of
the \fI-namespaces\fR option, if given, and to the namespaces
in scope of the context node at pre-compilation time. If the XPath
is found in the cache, neither the \fI-namespaces\fR option nor
the namespaces in scope of the context node will be taken in
account but the already resolved (stored) namespaces will be used
for the query.
.PP
Examples:

          
.CS
set paragraphNodes [$node selectNodes {chapter[3]//para[@type='warning' or @type='error'} ]
foreach paragraph $paragraphNodes {
    lappend  values [$paragraph selectNodes attribute::type]
}

set doc [dom parse {<doc xmlns="http://www.defaultnamespace.org"><child/></doc>}]
set root [$doc documentElement]
set childNodes [$root selectNodes -namespaces {default http://www.defaultnamespace.org} default:child]
.CE
.RE
.TP
\&\fB\fBbaseURI\fP \fI?URI?\fB
\&\fRReturns the present baseURI of the document. If the optional
argument URI is given, sets the base URI of the document to the given URI.
.TP
\&\fB\fBappendFromScript\fP \fItclScript\fB
\&\fRAppends the nodes created by the \fItclScript\fR by
Tcl functions, which have been built using \fIdom createNodeCmd\fR, at the end
of the current list of top level nodes of the document.
.TP
\&\fB\fBinsertBeforeFromScript\fP \fItclScript\fB \fIrefChild\fB
\&\fRInserts the nodes created in the \fItclScript\fR by Tcl
functions, which have been built using \fIdom
createNodeCmd\fR, before the \fIrefChild\fR into to the list
of top level nodes of the document. If \fIrefChild\fR is the
empty string, the new nodes will be appended.
.TP
\&\fB\fBdeleteXPathCache\fP \fI?xpathQuery?\fB
\&\fRIf called without the optional argument, all cached XPath
expressions of the document are freed. If called with the optional
argument \fIxpathQuery\fR, this single XPath query will be removed
from the cache, if it is there. The method always returns an
empty string.
.PP
Otherwise, if an unknown method name is given, the command with the
same name as the given metho within the namespace \fB::dom::domDoc\fR is
tried to be executed. This allows quick method additions on Tcl level.
.PP
Newly created nodes are appended to a hidden fragment list. If they
are not moved into the tree they are automaticaly deleted, when the whole
document gets deleted.
.SH "SEE ALSO"
dom, domNode
.SH KEYWORDS
DOM node creation, document element
