LOCAL_PATH := $(call my-dir)

##########################
#
# tkimg shared library
#
##########################

include $(CLEAR_VARS)

LOCAL_MODULE := tkimg

LOCAL_C_INCLUDES := \
	$(LOCAL_PATH)/../jpeg $(LOCAL_PATH)/../tiff/libtiff \
	$(LOCAL_PATH)/../libpng \
	$(LOCAL_PATH) \
	$(LOCAL_PATH)/base $(LOCAL_PATH)/pixmap $(LOCAL_PATH)/tiff \
	$(LOCAL_PATH)/../tcl/generic $(LOCAL_PATH)/../tcl/unix \
	$(LOCAL_PATH)/../sdl2tk $(LOCAL_PATH)/../sdl2tk/generic \
	$(LOCAL_PATH)/../sdl2tk/sdl $(LOCAL_PATH)/../sdl2tk/xlib

LOCAL_CFLAGS := \
        -DHAVE_LIMITS_H=1 \
        -DHAVE_UNISTD_H=1 \
        -DHAVE_SYS_PARAM_H=1 \
        -DTCL_WIDE_INT_TYPE="long long" \
        -DHAVE_GETCWD=1 \
        -DHAVE_OPENDIR=1 \
        -DHAVE_STRSTR=1 \
        -DHAVE_STRTOL=1 \
        -DHAVE_STRTOLL=1 \
        -DHAVE_STRTOULL=1 \
        -DHAVE_TMPNAM=1 \
        -DHAVE_WAITPID=1 \
        -DUSE_TERMIOS=1 \
        -DHAVE_SYS_TIME_H=1 \
        -DTIME_WITH_SYS_TIME=1 \
        -DHAVE_TM_ZONE=1 \
        -DHAVE_GMTIME_R=1 \
        -DHAVE_LOCALTIME_R=1 \
        -DHAVE_TM_GMTOFF=1 \
        -DHAVE_TIMEZONE_VAR=1 \
        -DHAVE_ST_BLKSIZE=1 \
        -DSTDC_HEADERS=1 \
        -DHAVE_SYS_IOCTL_H=1 \
        -DVOID=void \
        -DNO_UNION_WAIT=1 \
        -DPLATFORM_SDL=1 \
        -DNO_FD_SET=1 \
        -DTCL_NO_DEPRECATED \
	-DMODULE_SCOPE=extern \
	-DTKIMGAPI=extern \
	-DALLOW_B64=1 \
	-DPACKAGE_NAME="\"tkimg\"" \
	-DPACKAGE_VERSION="\"1.4\"" \
	-O2

LOCAL_SRC_FILES := \
	base/tkimg.c \
	base/tkimgIO.c \
	base/tkimgPPB.c \
	base/tkimgUtils.c \
	bmp/bmp.c \
	dted/dted.c \
	gif/gif.c \
	ico/ico.c \
	jpeg/jpeg.c \
	pcx/pcx.c \
	pixmap/pixmap.c \
	pixmap/pixmapUnix.c \
	png/png.c \
	ppm/ppm.c \
	raw/raw.c \
	sgi/sgi.c \
	sun/sun.c \
	tga/tga.c \
	tiff/tiff.c \
	tiff/tiffJpeg.c \
	tiff/tiffPixar.c \
	tiff/tiffZip.c \
	window/window.c \
	xbm/xbm.c \
	xpm/xpm.c

LOCAL_LDLIBS := -lz
LOCAL_STATIC_LIBRARIES :=
LOCAL_SHARED_LIBRARIES := jpeg_tkimg png_tkimg tiff_tkimg tcl tk

LOCAL_EXPORT_C_INCLUDES += $(LOCAL_C_INCLUDES)

include $(BUILD_SHARED_LIBRARY)

