package tk.tcl.wish;

import org.libsdl.app.SDLActivity;

import java.lang.reflect.*;
import java.util.*;
import java.util.concurrent.*;
import java.util.Map.*;
import java.io.*;
import android.os.*;
import android.net.*;
import android.app.*;
import android.content.*;
import android.content.pm.*;
import android.media.*;
import android.graphics.*;
import android.location.*;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TextToSpeech.*;
import android.net.*;
import android.util.*;
import android.bluetooth.*;
import android.widget.*;
import android.support.v4.app.NotificationCompat;

public class AndroWish extends SDLActivity implements LocationListener {

    protected static AndroWish mSingleton;
    protected static Vibrator mVibrator;
    protected static TextToSpeech mTTS;
    protected static CountDownLatch mTTSLock;
    protected static Map<String, Location> mLocations;
    protected static LocationManager mLocationMgr;
    protected static ConnectivityManager mConnMgr;
    protected static Object mNetLock;
    protected static NetworkInfo mNetworkInfo;
    protected static NotificationManager mNotificationMgr;

    /*
     * Callback on application startup
     */

    @Override
    public void onCreate(Bundle savedInstanceData) {
	super.onCreate(savedInstanceData);
	mSingleton = this;
	int glesVer = getGLESVersion(this);
	String lang = Locale.getDefault().toString();
	Log.v("AndroWish", "onCreate GLES=" + glesVer + " LANG=" + lang);
        nativeInit(glesVer, lang);
	mVibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
	mLocationMgr = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
	mLocations = new HashMap<String, Location>();
	mConnMgr = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
	mNotificationMgr = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
	mNetLock = new Object();
	IntentFilter filter = new IntentFilter();
	filter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
	BroadcastReceiver recvr = new BroadcastReceiver() {
	    @Override
	    public void onReceive(Context context, Intent intent) {
		synchronized (mNetLock) {
		    mNetworkInfo = mConnMgr.getActiveNetworkInfo();
		}
		mSingleton.nativeTriggerNetworkInfo();
	    }
	};
	registerReceiver(recvr, filter);
	filter = new IntentFilter();
	filter.addAction(BluetoothAdapter.ACTION_STATE_CHANGED);
	recvr = new BroadcastReceiver() {
	    @Override
	    public void onReceive(Context context, Intent intent) {
		mSingleton.nativeTriggerBluetooth();
	    }
	};
	registerReceiver(recvr, filter);
	filter = new IntentFilter();
	filter.addAction(BluetoothAdapter.ACTION_SCAN_MODE_CHANGED);
	recvr = new BroadcastReceiver() {
	    @Override
	    public void onReceive(Context context, Intent intent) {
		mSingleton.nativeTriggerBluetooth();
	    }
	};
	registerReceiver(recvr, filter);
    }

    /*
     * Find out if OpenGL ES >= 2.x is available.
     */

    private static int getGLESVersion(Context context) {
	final ActivityManager am =
	    (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
	final ConfigurationInfo ci = am.getDeviceConfigurationInfo();
	return (ci.reqGlEsVersion & 0xFFFF0000) >> 16;
    }

    /*
     * Callback to deal with activity results
     */

    @Override
    public void onActivityResult(int id, int ret, Intent i) {
	super.onActivityResult(id, ret, i);
	String action = null;
	String uristr = null;
	String type = null;
	String[] cats = null;
	String[] args = null;
	if (i != null) {
	    action = i.getAction();
	    uristr = i.getDataString();
	    type = i.getType();
	    if (i.getCategories() != null) {
		Set<String> cset = i.getCategories();
		args = new String[cset.size()];
		int k = 0;
		Iterator<String> it = cset.iterator();
		while (it.hasNext()) {
		    args[k++] = it.next();
		}
	    }
	    if (i.getExtras() != null) {
		Bundle extras = i.getExtras();
		Set<String> keys = extras.keySet();
		args = new String[keys.size() * 2];
		int k = 0;
		Iterator<String> it = keys.iterator();
		while (it.hasNext()) {
		    String key = it.next();
		    Object obj = extras.get(key);
		    args[k++] = key;
		    if (obj == null) {
			args[k] = new String("");
		    } else if (obj instanceof String) {
			args[k] = (String) obj;
		    } else if (obj instanceof byte[]) {
			args[k] =
			    Base64.encodeToString((byte[]) obj, Base64.DEFAULT);
		    } else if (obj instanceof Bitmap) {
			args[k] = encodeBitmap((Bitmap) obj);
		    } else {
			args[k] = obj.toString();
		    }
		    k++;
		}
	    }
	}
	Log.v("AndroWish", "nativeIntentCallback: " + id + "," + ret + "," +
	      action + "," + uristr + "," + type + "," + cats + "," + args);
	nativeIntentCallback(id, ret, action, uristr, type, cats, args);
    }

    String encodeBitmap(Bitmap bm) {
	ByteArrayOutputStream bs = new ByteArrayOutputStream();
	bm.compress(Bitmap.CompressFormat.JPEG, 80, bs);
	byte[] bytes = bs.toByteArray();
	bs = null;
	return Base64.encodeToString(bytes, Base64.DEFAULT);
    }

    /*
     * Run activity
     */

    public static int runActivity(String action, String uristr, String type,
				  String[] cats, String types[], String[] argv,
				  int id) {
	int err;
	err = (id < 0) ? (id - 1) : -100;
	try {
	    Uri uri = null;
	    Intent i = new Intent(action);
	    if (uristr != null && uristr.length() > 0) {
		uri = Uri.parse(uristr);
	    }
	    if (type != null && type.length() == 0) {
		type = null;
	    }
	    if (uri != null && type != null) {
		i.setDataAndType(uri, type);
	    } else if (uri != null) {
		i.setData(uri);
	    } else if (type != null) {
		i.setType(type);
	    }
	    if (cats != null) {
		int k;
		for (k = 0; k < cats.length; k++) {
		    i.addCategory(cats[k]);
		}
	    }
	    if (argv != null) {
		int k;
		for (k = 0; k < argv.length; k += 2) {
		    if (types[k] != null) {
			if (types[k].equals("int")) {
			    i.putExtra(argv[k], Integer.parseInt(argv[k + 1]));
			} else if (types[k].equals("long")) {
			    i.putExtra(argv[k], Long.parseLong(argv[k + 1]));
			} else if (types[k].equals("short")) {
			    i.putExtra(argv[k], Short.parseShort(argv[k + 1]));
			} else if (types[k].equals("char")) {
			    i.putExtra(argv[k], argv[k + 1].charAt(0));
			} else if (types[k].equals("byte")) {
			    i.putExtra(argv[k], Byte.parseByte(argv[k + 1]));
			} else if (types[k].equals("boolean")) {
			    i.putExtra(argv[k], Boolean.parseBoolean(argv[k + 1]));
			} else if (types[k].equals("float")) {
			    i.putExtra(argv[k], Float.parseFloat(argv[k + 1]));
			} else if (types[k].equals("double")) {
			    i.putExtra(argv[k], Double.parseDouble(argv[k + 1]));
			} else if (types[k].equals("Uri")) {
			    i.putExtra(argv[k], Uri.parse(argv[k + 1]));
			} else if (types[k].equals("String")) {
			    i.putExtra(argv[k], argv[k + 1]);
			} else {
			    i.putExtra(argv[k], argv[k + 1]);
			}
		    } else {
			i.putExtra(argv[k], argv[k + 1]);
		    }
		}
	    }
	    Runner r = new Runner(mSingleton, i, id);
	    mSingleton.runOnUiThread(r);
	} catch (Exception e) {
	    Log.v("AndroWish", "runActivity failed: " + e.toString());
	    return err;
	}
	return id;
    }

    /*
     * Query intents/activities
     */

    public static String[] queryIntents(int which, String action,
					String uristr, String type) {
	PackageManager packageManager = mSingleton.getPackageManager();
	List<String> apps = new ArrayList<String>();
	Intent i;
	List<ResolveInfo> acts;
	Uri uri = null;
	if (uristr != null && uristr.length() > 0) {
	    uri = Uri.parse(uristr);
	}
	if (type != null && type.length() == 0) {
	    type = null;
	}
	i = new Intent(action);
	if (uri != null && type != null) {
	    i.setDataAndType(uri, type);
	} else if (uri != null) {
	    i.setData(uri);
	} else if (type != null) {
	    i.setType(type);
	}
	switch (which) {
	default:
	    acts = packageManager.queryIntentActivities(i, 0);
	    break;
	case 1:
	    acts = packageManager.queryIntentServices(i, 0);
	    break;
	case 2:
	    acts = packageManager.queryBroadcastReceivers(i, 0);
	    break;
	}
	int k = 0;
        for (ResolveInfo res : acts) {
            ActivityInfo actinfo = res.activityInfo;
            if (actinfo != null) {
                apps.add(actinfo.name);
		k++;
	    }
        }
	String[] ret = new String[k];
	apps.toArray(ret);
	return ret;
    }

    /*
     * Notification by vibration
     */

    public static void vibrate(int duration) {
	if (duration <= 0) {
	    duration = 500;
	}
	mVibrator.vibrate(duration);
    }

    /*
     * Notification by ringtone
     */

    public static void beep() {
	Runnable beeper = new Runnable() {
	    public void run() {
		Uri ringuri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
		Ringtone tone = RingtoneManager.getRingtone(mSingleton.getBaseContext(), ringuri);
		if (tone != null && !tone.isPlaying()) {
		    tone.play();
		}
	    }	
	};
	mSingleton.runOnUiThread(beeper);
    }

    /*
     * Notification by toast
     */

    public static void toast(final String text, final int duration) {
	Runnable toaster = new Runnable() {
	    public void run() {
		Toast toast = Toast.makeText(mSingleton.getBaseContext(),
				             text, (duration > 0) ?
					     Toast.LENGTH_LONG : Toast.LENGTH_SHORT);
		if (toast != null) {
		    toast.show();
		}
	    }
	};
	mSingleton.runOnUiThread(toaster);
    }

    /*
     * Text-to-speech
     */

    public static int speak(final int op, final String text) {
	int ret = 0;
	if (op < 0) {
	    // shutdown
	    if (mTTS != null) {
		mTTS.stop();
		mTTS.shutdown();
		mTTS = null;
		mTTSLock = null;
	    }
	    return ret;
	}
	if (mTTS == null) {
	    mTTSLock = new CountDownLatch(1);
	    Runnable speaker = new Runnable() {
		public void run() {
		    mTTS = new TextToSpeech(mSingleton.getContext(), new OnInitListener() {
			    @Override
			    public void onInit(int status) {
				mTTSLock.countDown();
			    }
			});
		}
	    };
	    mSingleton.runOnUiThread(speaker);
	}
	try {
	    mTTSLock.await();
	    switch (op) {
	    case 0:
		mTTS.stop();
		break;
	    case 1:
		if (text != null) {
		    mTTS.speak(text, TextToSpeech.QUEUE_ADD, null);
		}
		break;
	    case 2:
		if (mTTS.isSpeaking()) {
		    ret = 1;
		}
		break;
	    }
	} catch (InterruptedException e) {
	    // shutdown
	    if (mTTS != null) {
		mTTS.shutdown();
		mTTS = null;
		mTTSLock = null;
	    }
	}
	return ret;
    }

    /*
     * Some reflection stuff
     */

    public static String[] queryConsts(String clsname) {
	List<String> list = new ArrayList<String>();
	int flags = Modifier.FINAL | Modifier.PUBLIC | Modifier.STATIC;
	int k = 0;
	try {
	    Class<?> cls = Class.forName(clsname);
	    for (Field field : cls.getFields()) {
		if ((field.getModifiers() & flags) == flags) {
		    Class<?> type = field.getType();
		    list.add(field.getName());
		    list.add(field.get(null).toString());
		    k += 2;
		}
	    }
	} catch (Exception e) {
	}
	String[] ret = new String[k];
	list.toArray(ret);
	return ret;
    }

    /*
     * Location handling
     */

    @Override
    public void onProviderDisabled(String provider) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onLocationChanged(Location location) {
	synchronized (mLocations) {
	    mLocations.put(location.getProvider(), location);
	}
	if (mSingleton.nativeTriggerLocation() < 0) {
	    stopLocating();
	}
    }

    public static String getLocation() {
	StringBuffer sb = new StringBuffer();
	int k = 0;
	synchronized (mLocations) {
	    for (Entry<String, Location> entry : mLocations.entrySet()) {
		Location loc = entry.getValue();
		if (loc.getProvider() != null) {
		    if (++k > 1) {
			sb.append(" ");
		    }
		    sb.append(loc.getProvider() + " ");
		    sb.append("{latitude " + loc.getLatitude());
		    sb.append(" longitude " + loc.getLongitude());
		    sb.append(" time " + (loc.getTime() / 1000));
		    sb.append(" velocity " + loc.getSpeed());
		    sb.append(" altitude " + loc.getAltitude());
		    sb.append(" bearing " + loc.getBearing());
		    sb.append(" accuracy " + loc.getAccuracy() + "}");
		}
	    }
	}
	return sb.toString();
    }

    public static void startLocating(final int minrate, final int mindist) {
	Runnable locStart = new Runnable() {
	    public void run() {
		for (String provider : mLocationMgr.getAllProviders()) {
		    mLocationMgr.requestLocationUpdates(provider,
							minrate, mindist,
							mSingleton);
		}
	    }
	};
	mSingleton.runOnUiThread(locStart);
    }

    public static void stopLocating() {
	mLocationMgr.removeUpdates(mSingleton);
	synchronized (mLocations) {
	    mLocations.clear();
	}
    }

    /*
     * Network/connectivity info
     */

    public static String getNetworkInfo() {
	String result = "none";
	synchronized (mNetLock) {
	    if (mNetworkInfo != null && mNetworkInfo.isConnected()) {
		String type = mNetworkInfo.getTypeName();
		if (type.toLowerCase().equals("mobile")) {
		    result = "mobile " + mNetworkInfo.getSubtypeName();
		} else {
		    result = type.toLowerCase();
		}
	    }
	}
	return result;
    }

    /*
     * Desktop shortcuts
     */

    public static void shortcut(int op, String name, String arg, String icon) {
	Intent shortcut;
	ComponentName comp = new ComponentName(mSingleton.getPackageName(),
					       ".AndroWishLauncher");
	Intent toRun = new Intent(Intent.ACTION_MAIN);
	Intent.ShortcutIconResource iconRes =
	    Intent.ShortcutIconResource.fromContext(mSingleton.getContext(),
						    R.drawable.wish);
	Bitmap iconBitmap = null;
	toRun.setComponent(comp);
	if (arg != null) {
	    toRun.putExtra("arg", arg);
	}
	if (icon != null) {
	    byte b[] = Base64.decode(icon, Base64.DEFAULT);
	    if (b != null && b.length > 0) {
		iconBitmap = BitmapFactory.decodeByteArray(b, 0, b.length);
	    }
	}
	switch (op) {
	case 0:		/* add */
	    shortcut = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
	    shortcut.putExtra(Intent.EXTRA_SHORTCUT_NAME, name);
	    shortcut.putExtra("duplicate", false);
	    shortcut.putExtra(Intent.EXTRA_SHORTCUT_INTENT, toRun);
	    if (iconBitmap != null) {
		shortcut.putExtra(Intent.EXTRA_SHORTCUT_ICON, iconBitmap);
	    } else {
		shortcut.putExtra(Intent.EXTRA_SHORTCUT_ICON_RESOURCE, iconRes);
	    }
	    Log.v("AndroWish", "add shortcut '" + name + "'" +
		  ((arg != null) ? (" -> '" + arg + "'") : ""));
 	    mSingleton.sendBroadcast(shortcut);
	    break;
	case 1:		/* delete */
	    shortcut = new Intent("com.android.launcher.action.UNINSTALL_SHORTCUT");
	    shortcut.putExtra(Intent.EXTRA_SHORTCUT_NAME, name);
	    shortcut.putExtra("duplicate", false);
	    shortcut.putExtra(Intent.EXTRA_SHORTCUT_INTENT, toRun);
	    if (iconBitmap != null) {
		shortcut.putExtra(Intent.EXTRA_SHORTCUT_ICON, iconBitmap);
	    } else {
		shortcut.putExtra(Intent.EXTRA_SHORTCUT_ICON_RESOURCE, iconRes);
	    }
	    Log.v("AndroWish", "delete shortcut '" + name + "'" +
		  ((arg != null) ? (" -> '" + arg + "'") : ""));
	    mSingleton.sendBroadcast(shortcut);
	    break;
	}
    }

    /*
     * Notifications
     */

    public static void notify(int op, int id, String title, String text) {
	switch (op) {
	case 0:		/* add/modify */
	    if (android.os.Build.VERSION.SDK_INT <
		android.os.Build.VERSION_CODES.HONEYCOMB) {
		Notification n =
		     new Notification(R.drawable.wish, title,
				      System.currentTimeMillis());
		n.flags = Notification.FLAG_ONGOING_EVENT;
		PendingIntent pi =
		    PendingIntent.getActivity(mSingleton.getContext(),
					      0, new Intent(), 0);
		n.setLatestEventInfo(mSingleton.getContext(), title, text, pi);
		mNotificationMgr.notify(id, n);
		break;
	    }
	    NotificationCompat.Builder nb =
		new NotificationCompat.Builder(mSingleton.getContext());
	    nb.setSmallIcon(R.drawable.wish);
	    nb.setContentTitle(title);
	    nb.setContentText(text);
	    nb.setAutoCancel(true);
	    PendingIntent pi =
		PendingIntent.getActivity(mSingleton.getContext(),
					  0, new Intent(), 0);
	    nb.setContentIntent(pi);
	    mNotificationMgr.notify(id, nb.build());
	    break;
	case 1:		/* delete */
	    mNotificationMgr.cancel(id);
	    break;
	case 2:		/* delete all */
	    mNotificationMgr.cancelAll();
	    break;
	}
    }

    /*
     * Bluetooth
     */

    public static String[] bluetooth(int op, String arg) {
	BluetoothAdapter btAdap = BluetoothAdapter.getDefaultAdapter();
	String result[];
	int i;
	switch (op) {
	case 0:		/* devices */
	    Set<BluetoothDevice> btDevs = btAdap.getBondedDevices();
	    i = 0;
	    for (BluetoothDevice dev : btDevs) {
		i++;
	    }
	    result = new String[i * 2];
	    i = 0;
	    for (BluetoothDevice dev : btDevs) {
		result[i++] = dev.getAddress();
		result[i++] = dev.getName();
	    }
	    return result;
	case 1:		/* state */
	    result = new String[1];
	    result[0] = btAdap.isEnabled() ? "on" : "off";
	    return result;
	case 2:		/* scanmode */
	    result = new String[1];
	    i = btAdap.getState();
	    if (i == BluetoothAdapter.STATE_OFF ||
		i == BluetoothAdapter.STATE_TURNING_OFF) {
		result[0] = "off";
		return result;
	    }
	    i = btAdap.getScanMode();
	    if (i == BluetoothAdapter.SCAN_MODE_NONE) {
		result[0] = "passive";
	    } else if (i == BluetoothAdapter.SCAN_MODE_CONNECTABLE) {
		result[0] = "connectable";
	    } else if (i == BluetoothAdapter.SCAN_MODE_CONNECTABLE_DISCOVERABLE) {
		result[0] = "visible";
	    } else {
		result[0] = "on";
	    }
	    return result;
	case 3:		/* myaddress */
	    result = new String[2];
	    result[0] = btAdap.getAddress();
	    result[1] = btAdap.getName();
	    return result;
	case 4:		/* remoteaddress */
	    try {
		BluetoothDevice btDev = btAdap.getRemoteDevice(arg);
		result = new String[1];
		result[0] = btDev.getName();
		return result;
	    } catch(Exception e) {
	    }
	    return null;
	}
	return null;
    }

    /*
     * Native initializer
     */

    public static native void nativeInit(int api, String lang);

    /*
     * Native set file to be sourced
     */

    public static native void nativeSetStartupFile(String file);

    /*
     * Callback when activity reports result back
     */

    public static native void nativeIntentCallback(int id, int ret,
						   String action,
						   String uristr,
						   String type,
						   String[] cats,
						   String[] args);

    /*
     * Callback to indicate location update
     */

    public static native int nativeTriggerLocation();

    /*
     * Callback to indicate network status update
     */

    public static native int nativeTriggerNetworkInfo();

    /*
     * Callback to indicate bluetooth status update
     */

    public static native int nativeTriggerBluetooth();

}

/*
 * Helper class to carry out activity
 */

class Runner implements Runnable {
    AndroWish a;
    Intent i;
    int id;

    public Runner(AndroWish a, Intent i, int id) {
        this.a = a;
        this.i = i;
	this.id = id;
    }

    public void run() {
	try {
	    if (id < 0) {
		a.startActivity(i);
	    } else {
		a.startActivityForResult(i, id);
	    }
	} catch (Exception e) {
	}
    }
}

class AndroWishScript extends AndroWish {

    /*
     * Callback on application startup
     */

    @Override
    public void onCreate(Bundle savedInstanceData) {
	Intent intent = getIntent();
	String file = intent.getStringExtra("arg");
	if (file == null) {
	    file = intent.getDataString();
	}
	super.onCreate(savedInstanceData);
	if (file == null) {
	    finish();
	    return;
	}
	Log.v("AndroWish", "run script '" + file + "'");
	nativeSetStartupFile(file);
    }

}
