package tk.tcl.wish;

import java.util.*;
import android.os.*;
import android.app.*;
import android.app.ActivityManager.*;
import android.content.*;
import android.content.pm.*;
import android.net.*;
import android.util.*;

public class AndroWishLauncher extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceData) {
	super.onCreate(savedInstanceData);
	Log.v("AndroWishLauncher", "onCreate");
	String arg = null;
	Intent intent = getIntent();
	if (intent.getAction().equalsIgnoreCase(Intent.ACTION_SEND)) {
	    if (intent.hasExtra(Intent.EXTRA_STREAM)) {
		Uri uri = (Uri) intent.getParcelableExtra(Intent.EXTRA_STREAM);
		if (uri != null) {
		    arg = uri.toString();
		}
	    }
	} else if ((arg = intent.getStringExtra("arg")) == null) {
	    if (intent.getData() == null ||
		intent.getData().getPath() == null) {
		Log.v("AndroWishLauncher", "*** no file given");
		finish();
		return;
	    }
	}
	ActivityManager am =
	    (ActivityManager) getSystemService(ACTIVITY_SERVICE);
	List<RunningAppProcessInfo> procs = am.getRunningAppProcesses();
	boolean[] flags = new boolean[4];
	for (RunningAppProcessInfo pi : procs) {
	    if ("tk.tcl.wish:S0".equals(pi.processName)) {
		flags[0] = true;
	    }
	    if ("tk.tcl.wish:S1".equals(pi.processName)) {
		flags[1] = true;
	    }
	    if ("tk.tcl.wish:S2".equals(pi.processName)) {
		flags[2] = true;
	    }
	    if ("tk.tcl.wish:S3".equals(pi.processName)) {
		flags[3] = true;
	    }
	}
	Class cls = null;
	if (!flags[0]) {
	    cls = tk.tcl.wish.AndroWishScript0.class;
	} else if (!flags[1]) {
	    cls = tk.tcl.wish.AndroWishScript1.class;
	} else if (!flags[2]) {
	    cls = tk.tcl.wish.AndroWishScript2.class;
	} else if (!flags[3]) {
	    cls = tk.tcl.wish.AndroWishScript3.class;
	}
	if (cls != null) {
	    Log.v("AndroWishLauncher", "*** new intent " + cls.toString());
	    intent = new Intent(Intent.ACTION_VIEW, intent.getData(),
				this, cls);
	    if (arg != null) {
		intent.putExtra("arg", arg);
	    }
	    startActivity(intent);
	}
    }

    @Override
    protected void onPause() {
        Log.v("AndroWishLauncher", "onPause()");
	finish();
	super.onPause();
    }

    @Override
    protected void onResume() {
        Log.v("AndroWishLauncher", "onResume()");
	finish();
	super.onResume();
    }

}
