package tk.tcl.wish;

import java.io.*;
import java.util.*;
import java.net.*;
import android.bluetooth.*;
import android.util.Log;

public class BTClient {

    private FileDescriptor fd;
    private BluetoothSocket sock;
    private IOThread io1, io2;

    public BTClient(FileDescriptor fd, String bdaddr, String uuid) {
        BluetoothAdapter bt = BluetoothAdapter.getDefaultAdapter();
        BluetoothDevice dev = null;
        try {
            dev = bt.getRemoteDevice(bdaddr);
            sock = dev.createRfcommSocketToServiceRecord(UUID.fromString(uuid));
            sock.connect();
	    io1 = new IOThread(this, sock.getInputStream(),
			       new FileOutputStream(fd));
	    io2 = new IOThread(this, new FileInputStream(fd),
			       sock.getOutputStream());
	    io1.start();
	    io2.start();
	    this.fd = fd;
        } catch (Exception e) {
            Log.e("BTClient", "<init>: " + e);
            this.sock = null;
	    throw new RuntimeException("can't connect");
        }
    }

    public BTClient(FileDescriptor fd, BluetoothSocket sock) {
        try {
	    io1 = new IOThread(this, sock.getInputStream(),
			       new FileOutputStream(fd));
	    io2 = new IOThread(this, new FileInputStream(fd),
			       sock.getOutputStream());
	    io1.start();
	    io2.start();
	    this.sock = sock;
	    this.fd = fd;
        } catch (Exception e) {
            Log.e("BTClient", "<init>: " + e);
            this.sock = null;
	    throw new RuntimeException("can't connect");
        }
    }

    public String peername() {
	String ret = null;
        try {
	    BluetoothDevice dev = sock.getRemoteDevice();
	    ret = dev.getAddress();
        } catch (Exception e) {
            Log.e("BTClient", "peername: " + e);
        }
	return ret;
    }

    public void close() {
	try {
	    if (sock != null) {
		sock.close();
		sock = null;
	    }
	} catch (Exception e) {
	}
    }

    public static native void shutdown(FileDescriptor fd);

    private class IOLoop {

        private InputStream in;
        private OutputStream out;

        public IOLoop(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void loop() {
            byte buf[] = new byte[1024];
            while (true) {
                try {
                    int data = in.read();
                    if (data < 0) {
                        break;
                    }
                    buf[0] = (byte) data;
                    int n = in.available();
                    if (n > 0) {
                        if (n > buf.length - 1) {
                            n = buf.length - 1;
                        }
                        n = in.read(buf, 1, n);
                        if (n < 0) {
                            break;
                        }
                        n++;
                    } else {
                        n = 1;
                    }
                    out.write(buf, 0, n);
                } catch (IOException e) {
		    Log.e("BTClient", "loop: " + e);
                    break;
                }
            }
	    try {
		in.close();
	    } catch (IOException e) {
	    }
	    try {
		out.close();
	    } catch (IOException e) {
	    }
        }
    }

    private class IOThread extends Thread {

        private InputStream in;
        private OutputStream out;
	private BTClient btc;

        public IOThread(BTClient btc, InputStream in, OutputStream out) {
	    this.btc = btc;
            this.in = in;
            this.out = out;
        }

        public void run() {
	    Log.e("BTClient", "IOThread: start");
            IOLoop loop = new IOLoop(in, out);
            loop.loop();
	    btc.close();
	    BTClient.shutdown(btc.fd);
	    Log.e("BTClient", "IOThread: end");
        }
    }
}
