package tk.tcl.wish;

import java.io.*;
import java.util.*;
import java.net.*;
import android.bluetooth.*;
import android.util.Log;

public class BTServer extends Thread {

    private FileDescriptor fd;
    private BluetoothServerSocket sock;
    private BluetoothSocket newsock;
    private Object lock;
    private Thread thread;

    public BTServer(FileDescriptor fd, String name, String uuid) {
        BluetoothAdapter bt = BluetoothAdapter.getDefaultAdapter();
	lock = new Object();
	try {
	    sock = bt.listenUsingRfcommWithServiceRecord(name,
							 UUID.fromString(uuid));
	    this.fd = fd;
	    thread = new Thread(this);
	    thread.start();
        } catch (Exception e) {
            Log.e("BTServer", "<init>: " + e);
            this.sock = null;
	    throw new RuntimeException("can't listen");
        }
    }

    public void run() {
	FileOutputStream out = new FileOutputStream(fd);
	while (true) {
	    try {
		synchronized (lock) {
		    newsock = sock.accept();
		    out.write((int) 'A');
		    lock.wait(15000);
		    if (newsock != null) {
			newsock.close();
			newsock = null;
		    }
		}
	    } catch (Exception e) {
		Log.e("BTServer", "run: " + e);
		try {
		    sock.close();
		    out.close();
		} catch (Exception ee) {
		}
		break;
	    }
	}
	thread = null;
    }

    public BTClient accept(FileDescriptor fd) {
	BTClient client = null;
	synchronized (lock) {
	    if (newsock != null) {
		client = new BTClient(fd, newsock);
		newsock = null;
		lock.notifyAll();
	    }
	}
	return client;
    }

    public void close() {
	if (thread != null) {
	    thread.interrupt();
	}
	try {
	    sock.close();
	    sock = null;
	} catch (Exception e) {
	}
    }

}
